/*  Hey Emacs, switch to -*-C-*-, please 

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.

 */

#include <sys/types.h>
#include <stdio.h>
#include <md5.h>
#include <sys/uio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>

#include "pgplib.h"

char *Progname;

void
usage()
{
    fprintf(stderr,
	    "usage: %s [-a] -d database -f file -p password -u user\n",
	    Progname);
    exit(1);
}

void
main(int argc, char *argv[])
{
    int		ch;
    extern char	*optarg;
    char 	*database;
    int		infile, outfile;
    char	*filename;
    u_char	digest[16];
    int		digest_ok;
    char 	*username;
    u_quad_t	*keys;
    PGPpubkey_t	*pubkey;
    PGPliteral_t literal;
    int		armor;
    int		num_keys;
    int		buflen;
    /* scratch */
    int		i,j;
    u_char 	*tmp, *ptr;

    Progname = argv[0];

    armor = 0;
    database = NULL;
    filename = NULL;
    outfile = infile = -1;
    digest_ok = 0;
    while ((ch = getopt (argc, argv, "a:d:f:p:u:")) != -1) {
	switch (ch) {
	case 'a': 
	    armor = 1;
	    break;
	case 'd':
	    database = optarg;
	    i = keydb_init(optarg, READER);
	    if ( i != 0 )
		usage();
	    break;
	case 'f':
	    i = access(optarg, R_OK);
	    if ( i < 0 ) {
		perror(optarg);
		usage();
	    }
	    filename = calloc(1, strlen(optarg) + 4 + 1);
	    if ( filename == NULL ) {
		fprintf(stderr, "Out of memory\n");
		exit(1);
	    }
	    strcpy(filename, optarg);
	    break;
	case 'p':
	    MD5(optarg, strlen(optarg), digest);
	    digest_ok = 1;
	    break;
	    
	case 'u':
	    username = optarg;
	    break;
	case '?':
	default:
	    usage();
	}
    }

    if ( database == NULL || filename == NULL || digest_ok == 0)
	usage();
    
    num_keys = find_keys_from_string(username, 0, &keys);
    if ( num_keys == -1 ) {
	fprintf(stderr, "Error finding keys\n");
	exit(1);
    }
    if ( num_keys > 1 ) {
	PGPuserid_t	**uids;

	fprintf(stdout, "Found more than one key\n");
	for( ; num_keys-1 >= 0; num_keys -= 1) {
	    i = find_uids_with_key(keys[num_keys], &uids);
	    if ( i == -1 ) {
		fprintf(stderr, "Error while finding uids\n");
		exit(1);
	    }
	    if ( i != 0 ) {
		j=0;
		while (uids[j] != NULL ) {
		    fprintf(stdout, "\t%s\n", uids[j]->name);
		    free_uid(uids[j]);
		    j += 1;
		}
		free(uids);
		
		continue;
	    }
	}

	exit(1);
    }

    /* OK, only one key. */

    i = fetch_only_pubkey(keys[0], &pubkey);
    if ( i != NULL ) {
	fprintf(stderr, "Didn't find key\n");
	exit(1);
    }
    free(keys);
    
    i = create_literal(filename, &literal);
    if ( i != 0 ) {
	fprintf(stderr, "Failed to create literal from %s\n", filename);
	exit(1);
    }
    i = literal_to_buf(&literal, &tmp);
    if ( i != 0 ) {
	fprintf(stderr, "Failed to create literal buffer\n");
	exit(1);
    }

    i = pub_encrypt_buffer(pubkey, tmp, literal.length, 0,
			   digest, &buflen, &ptr);
    if ( i != 0 ) {
	fprintf(stderr, "Failed to encrypt\n");
	exit(1);
    }
    free(&literal);
    free(tmp);

    if ( armor == 1 ) {
	i = armor_buffer(ptr, buflen, (char **)&tmp, &j);
	if ( i < 0 ) {
	    fprintf(stderr, "Could not armor\n");
	    exit(1);
	}
	free(ptr);
	ptr = tmp;
	buflen = j;
    }

    strcat(filename, ".pgp");
    outfile = open(filename, O_WRONLY|O_CREAT, 0600);
    if ( outfile < 0 ) {
	perror("creat");
	usage();
    }

    i = write(outfile, ptr, buflen);
    if ( i < 0 ) {
	perror("write");
	fprintf(stderr, "Cound not write result\n");
	exit(1);
    }

    exit(0);
}
