/*
 *  SecuDE Release 4.1 (GMD)
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include <malloc.h>
#include <stdio.h>

#define MAXMLIST 4096
#define FALSE       0
#define TRUE        1

static struct {
	char 		*maddr;
	unsigned 	 msize;
	char		*mproc;
} mlist[MAXMLIST];

unsigned mindex, allsize;
extern char MF_check;
extern int sec_debug;

char *MFtrace = 0;
char MFfound = 0;

void mftrace() {}
static void malloc_panic();

void settrace(addr)
char *addr;
{
	MFtrace = addr;
	sec_debug = 2;
}

#ifdef __HP__
static void  mlist_check(cmd, proc)
char           *cmd, *proc;
{

	int *real_size;
	int  i;
	if (!MFfound)
	for(i = 0; i < mindex; i++) {
		real_size = (int *)mlist[i].maddr;
		if (real_size[-1] < 0 || real_size[-1] >= 0x1000000) {
			fprintf(stderr, "Warning Malloc/Free: Bad length 0x%x of address 0x%x with size 0x%x (allocated in %s) detected in %s in %s\n",real_size[-1], mlist[i].maddr, mlist[i].msize, mlist[i].mproc, cmd, proc);
			MFfound = 1;
		}
	}
}
#endif

static void  mlist_lookup(cmd, proc, ptr)
char           *cmd, *proc, *ptr;
{
	int  i;
	for(i = 0; i < mindex; i++) {
		if (ptr == mlist[i].maddr) {
			fprintf(stderr, "Warning Malloc/Free: %s in %s: Address 0x%x is already allocated with size 0x%x in %s \n",cmd , proc, ptr, mlist[i].msize, mlist[i].mproc);
		}
	}

}

char *
aux_malloc(proc, size)
char           *proc;
unsigned        size;
{
	char           *addr;

#ifdef __HP__
	mlist_check("malloc", proc);
#endif

	if(!size) size = 4;
	addr = calloc(1, size);
	if(!addr) malloc_panic(proc, "malloc", size, (char *)0);

	if(MF_check) {
	        if(sec_debug > 1) fprintf(stderr, "        Block with address 0x%x and size %d allocated in %s\n", addr, size, proc);
		if(addr == MFtrace) mftrace();
		mlist_lookup("malloc", proc, addr);
		if(mindex < MAXMLIST) {
			mlist[mindex].maddr = addr;
			mlist[mindex].msize = size;
			mlist[mindex].mproc = proc;
			allsize += size;
			mindex++;
		}
		else {
			fprintf(stderr, "Warning Malloc/Free: MAXMLIST too small. MF_check deactivated\n");
			MF_check = FALSE;
		}
	}

	return (addr);
}


char *
aux_calloc(proc, elem, size)
char           *proc;
unsigned        elem, size;
{
	char           *addr;

#ifdef __HP__
	mlist_check("calloc", proc);
#endif


	if(!elem) elem = 1;
	if(!size) size = 4;
	addr = calloc(elem, size);
	if(!addr) malloc_panic(proc, "calloc", elem*size, (char *)0);

	if(MF_check) {
	        if(sec_debug > 1) fprintf(stderr, "        Block with address 0x%x and size %d allocated in %s\n", addr, size * elem, proc);
		if(addr == MFtrace) mftrace();
		mlist_lookup("calloc", proc, addr);

		if(mindex < MAXMLIST) {
			mlist[mindex].maddr = addr;
			mlist[mindex].msize = size * elem;
			mlist[mindex].mproc = proc;
			allsize += (size * elem);
			mindex++;
		}
		else {
			fprintf(stderr, "Warning Malloc/Free: MAXMLIST too small. MF_check deactivated\n");
			MF_check = FALSE;
		}
	}

	return (addr);
}

char           *
aux_realloc(proc, ptr, size)
char          *proc;
char          *ptr;
unsigned       size;
{
	char           *addr;
	int             i;

#ifdef __HP__
	mlist_check("realloc", proc);
#endif


	if(!size) size = 4;
	addr = realloc(ptr, size);
	if(!addr) malloc_panic(proc, "realloc", size, ptr);

	if(MF_check) {
			
		if(addr == MFtrace) mftrace();

		for(i = 0; i < mindex && mlist[i].maddr != ptr; i++);
		if(i < mindex) {
			allsize += size - mlist[i].msize;
			mlist[i].maddr = addr;
			mlist[i].msize = size;
			mlist[i].mproc = proc;
		        if(sec_debug > 1) fprintf(stderr, "        Block with address 0x%x and size %d reallocated in %s\n", addr, size, proc);
		} 
		else {
	        	fprintf(stderr, "Warning Malloc/Free: Block with address 0x%x and size %d reallocated in %s but not found in table\n", addr, size, proc);
			mlist[mindex].maddr = addr;
			mlist[mindex].msize = size;
			mlist[mindex].mproc = proc;
			allsize += size;
			mindex++;
		}


	}

	return (addr);
}

void 
aux_free(proc, ptr)
char           *proc, *ptr;
{
	int             ret = 0, i;

#ifdef __HP__
	mlist_check("free", proc);
#endif

	if(!MF_check) {
		if(ptr) free(ptr);
		return;
	}

	if(ptr) {
		if(ptr == MFtrace) mftrace();
		for(i = 0; i < mindex; i++) {
			if(mlist[i].maddr == ptr) {
				if(i < mindex - 1) {
					allsize -= mlist[i].msize;
					mlist[i].maddr = mlist[mindex - 1].maddr;
					mlist[i].msize = mlist[mindex - 1].msize;
					mlist[i].mproc = mlist[mindex - 1].mproc;
				}
				else allsize -= mlist[i].msize;
				mlist[mindex - 1].maddr = (char *)0;
				mindex--;
				if(sec_debug > 1) fprintf(stderr, "        Block with address 0x%x freed in %s\n", ptr, proc);

				free(ptr); 
				return;
			}
		}
		fprintf(stderr, "Warning Malloc/Free: Bad address 0x%x in free in %s\n", ptr, proc);
	}
	else fprintf(stderr, "Warning Malloc/Free: NULL pointer in free in %s\n", proc);
	return;
}

void MF_fprint(fp) 
FILE *fp;
{

	int i;

	fprintf(fp, "%d addresses currently allocated\n", mindex);
	fprintf(fp, "%d octets of memory currently allocated\n", allsize);
	if(sec_debug > 1) for(i = 0; i < mindex; i++) fprintf(fp, "addr = 0x%x allocated in %s, %d octets\n", mlist[i].maddr, mlist[i].mproc, mlist[i].msize);
}

void MF_fprint_stderr() {

	MF_fprint(stderr);

}

static void malloc_panic(proc, alloc, size, ptr) 
char *proc, *alloc, *ptr;
int size;
{
	fprintf(stderr, "\n!!! PANIC: can't %s %d octets in %s\n", alloc, size, proc);
	if(!strcmp(alloc, "realloc")) fprintf(stderr, "           tried to realloc address %04X\n", ptr);
	MF_fprint(stderr);
	exit(-1);
}

