# Test some numerical primitives.
# This also indirectly tests a bunch of other stuff.

#:count=NEW
#count:=0
:|(check :message :x :y)=
  if x=y => (stderr printf "OK: %s\n" message) || (stderr printf "ERROR: %s <%s;%s>\n" message x y)

# Tests of mod and rem.
# Compare: Steele: Common Lisp, the Language, 2nd edition, page 353.

check "modI1" (13 mod 4) 1
check "modI2" (-13 mod 4) 3
check "modI3" (13 mod -4) -3
check "modI4" (-13 mod -4) (-1)
check "modQ5" (134/10 mod 1) 4/10
check "modF5" (sprintf "%.2f" (13.4 mod 1)) "0.40"
check "modQ6" (-134/10 mod 1) 6/10
check "modF6" (sprintf "%.2f" (-13.4 mod 1)) "0.60"
check "remI1" (13 rem 4) 1
check "remI2" (-13 rem 4) -1

check "remI3" (13 rem -4) 1
check "remI4" (-13 rem -4) (-1)
check "remQ5" (134/10 rem 1) 4/10

check "div1" 4354354350/434 2177177175/217

check "remF5" (sprintf "%.2f" (13.4 rem 1)) "0.40"
check "remQ6" (-134/10 rem 1) -4/10
check "remF6" (sprintf "%.2f" (-13.4 rem 1)) "-0.40"

check "shifta" (10 shift 100) 12676506002282294014967032053760

# A problem posed by Ken Dickey (kend@data.UUCP) on comp.lang.lisp
# to check numerical exactness of Lisp implementations.

:(f :x :y)=((1335/4 * y**6) + (x**2 * ((11 * x**2 * y**2) - y**6 - (121 * y**4) - 2)) + (11/2 * y**8) + (x / 2*y))

#:(f :x :y)=(438605750846393161930703831040 +  (6024398689 *  (72586759116001040064-1314174534371215466459037696-145173518207904485376-2)) + 7917111340668961361101134701524942848 + 77617/66192)

check "IntExp" (f 77617 33096) (-54767/66192)

# Fibonacci numbers
:(Fib :i)=if i<2 => 1 || FibCache(i-1) + FibCache(i-2)
:FibCache = {Fib ?}

check "Fib0" (Fib 0) 1
check "Fib1" (Fib 1) 1
check "Fib3" (Fib 3) 3
check "Fib5" (Fib 5) 8
check "Fib100" (Fib 100) 573147844013817084101
check "Fib200" (Fib 200) 453973694165307953197296969697410619233826

#printf "[Done %d tests. Should be %d tests.]\n" count 32
