/*
    I haven't bothered to include a ".cinit" section in the CMD file, so
    don't use initializing declarations like "int x = 4;" or the linker
    will complain. I didn't want to drag along the entire C run-time
    library, which would bring in a bunch of irrelevant C startup code.
    The work-around for not using this code is to run C's stack out of
    a declared array (cryptically called "c_stack"), and initialize AR1
    to point to it before calling main(). This is set up in FUNC.ASM.
*/

#include "sample.h"
/* Things borrowed from FUNC.ASM */
extern int random(void); /* XORs and shifts and whatnot */
extern int waves, y, y1, coeff; /* used by sinewave routine */

int c_stack[40];

#define REPEAT 10000
#define N 5
int m1[N][N], m2[N][N], m3[N][N]; /* mmmm, matrices, mmmm */
/*     ^-----------rows */
/*        ^-----columns */

void randomize_matrices(void)
    {
    int i, j;

    for (i = 0; i < N; i++)
        for (j = 0; j < N; j++)
            {
            m1[i][j] = random();
            m2[i][j] = random();
            m3[i][j] = random();
            }
    }

void matrix_multiply(void)
    {
    int i, j, k;

    for (i = 0; i < N; i++)
        for (j = 0; j < N; j++)
            for (m3[i][j] = 0, k = 0; k < N; k++)
                m3[i][j] += m1[i][k] * m2[k][j];
    }

/*
    random_beeps() fools around (uncomprehendingly) with the sinewave
    generator, creating a potentially annoying sequence of beeps of random
    duration. Some of the noises are clearly NOT sinewaves; something may
    be clipping.
*/

int foo;  /* time-waster, slower because not a local variable */
/* interesting: a do-nothing loop with a local vbl is optimized out */

void random_beeps(void)
    {
    uint counter;

    while (1)
        {
        y = random();
        y1 = random();
        coeff = random();
        for (counter = (uint) random(); counter > 0; counter--)
            for (foo = 0; foo < 20; foo++);
        }
    }

void main(void)
    {
    int i, j;

    randomize_matrices();
    while (1)
        {
        for (i = 0; i < REPEAT; i++) matrix_multiply();
        waves = 0;
        for (i = 0; i < REPEAT; i++) matrix_multiply();
        waves = 1;
        }
    }

