#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "time.h"

const char
    *months[] = { "January", "February", "March", "April",
                  "May", "June", "July", "August",
                  "September", "October", "November", "December" },
    *weekdays[] = { "Sunday", "Monday", "Tuesday", "Wednesday",
                  "Thursday", "Friday", "Saturday", };

char temp[100];
#define WIDTH 75

void stars(void)
    {
    unsigned int i;

    for (i = 0; i < WIDTH; i++) printf("*");
    printf("\n");
    }

void center_justify(char *s)
    {
    int i;

    printf("*");
    for (i = 1; i < (WIDTH - (int) strlen(s)) / 2; i++) printf(" ");
    printf("%s", s);
    i += strlen(s);
    for ( ; i < WIDTH - 1; i++) printf(" ");
    printf("*\n", s);
    }

void main(int argc, char *argv[])
    {
    time_t T;
    struct tm *S;
    char *am_pm;

    time(&T);
    S = localtime(&T);
    am_pm = (S->tm_hour < 12) ? "AM" : "PM";
    if (S->tm_hour == 0) { S->tm_hour = 12; }
    else if (S->tm_hour > 12) { S->tm_hour -= 12; }
    sprintf(temp, "%02d:%02d:%02d %s - %s - %d %s %d",
        S->tm_hour, S->tm_min, S->tm_sec, am_pm, weekdays[S->tm_wday],
        S->tm_mday, months[S->tm_mon], S->tm_year + 1900);
    stars();
    center_justify("");
    if (argc > 1) center_justify(argv[1]);
    center_justify(temp);
    center_justify("");
    stars();
    printf("\n");
    exit(0);
    }
