/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.client.JDAPMessage;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPSearchResponse;
import netscape.ldap.client.opers.JDAPSearchResultReference;

public class LDAPSearchResults
implements Enumeration {
    private Vector entries;
    private LDAPSearchListener resultSource;
    private boolean searchComplete = true;
    private LDAPConnection connectionToClose = null;
    private LDAPConnection currConn;
    private boolean persistentSearch = false;
    private LDAPSearchConstraints currCons;
    private String currBase;
    private int currScope;
    private String currFilter;
    private String[] currAttrs;
    private boolean currAttrsOnly;
    private Vector referralResults = new Vector();
    private Vector exceptions;
    private boolean firstResult = false;

    public LDAPSearchResults() {
        this.entries = new Vector();
    }

    LDAPSearchResults(LDAPConnection lDAPConnection, LDAPSearchConstraints lDAPSearchConstraints, String string, int n, String string2, String[] stringArray, boolean bl) {
        this();
        this.currConn = lDAPConnection;
        this.currCons = lDAPSearchConstraints;
        this.currBase = string;
        this.currScope = n;
        this.currFilter = string2;
        this.currAttrs = stringArray;
        this.currAttrsOnly = bl;
    }

    LDAPSearchResults(Vector vector) {
        this();
        this.entries = (Vector)vector.clone();
        if (this.entries != null && this.entries.size() >= 1) {
            this.entries.removeElementAt(0);
        }
    }

    LDAPSearchResults(Vector vector, LDAPConnection lDAPConnection, LDAPSearchConstraints lDAPSearchConstraints, String string, int n, String string2, String[] stringArray, boolean bl) {
        this(vector);
        this.currConn = lDAPConnection;
        this.currCons = lDAPSearchConstraints;
        this.currBase = string;
        this.currScope = n;
        this.currFilter = string2;
        this.currAttrs = stringArray;
        this.currAttrsOnly = bl;
    }

    void add(JDAPProtocolOp jDAPProtocolOp) {
        if (jDAPProtocolOp instanceof JDAPSearchResponse) {
            this.add((JDAPSearchResponse)jDAPProtocolOp);
            return;
        }
        if (jDAPProtocolOp instanceof JDAPSearchResultReference) {
            this.add((JDAPSearchResultReference)jDAPProtocolOp);
        }
    }

    void add(JDAPSearchResponse jDAPSearchResponse) {
        LDAPAttribute[] lDAPAttributeArray = jDAPSearchResponse.getAttributes();
        LDAPAttributeSet lDAPAttributeSet = lDAPAttributeArray != null ? new LDAPAttributeSet(lDAPAttributeArray) : new LDAPAttributeSet();
        String string = jDAPSearchResponse.getObjectName();
        LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
        this.entries.addElement(lDAPEntry);
    }

    void add(JDAPSearchResultReference jDAPSearchResultReference) {
        String[] stringArray = jDAPSearchResultReference.getUrls();
        if (stringArray != null) {
            if (this.exceptions == null) {
                this.exceptions = new Vector();
            }
            this.exceptions.addElement(new LDAPReferralException(null, 0, stringArray));
        }
    }

    void add(LDAPException lDAPException) {
        if (this.exceptions == null) {
            this.exceptions = new Vector();
        }
        this.exceptions.addElement(lDAPException);
    }

    void associate(LDAPSearchListener lDAPSearchListener) {
        this.resultSource = lDAPSearchListener;
        this.searchComplete = false;
    }

    void associatePersistentSearch(LDAPSearchListener lDAPSearchListener) {
        this.resultSource = lDAPSearchListener;
        this.persistentSearch = true;
        this.searchComplete = false;
        this.firstResult = true;
    }

    void addReferralEntries(LDAPSearchResults lDAPSearchResults) {
        this.referralResults.addElement(lDAPSearchResults);
    }

    void closeOnCompletion(LDAPConnection lDAPConnection) {
        if (this.searchComplete) {
            try {
                lDAPConnection.disconnect();
                return;
            }
            catch (LDAPException lDAPException) {
                return;
            }
        }
        this.connectionToClose = lDAPConnection;
    }

    void quicksort(LDAPEntry[] lDAPEntryArray, LDAPEntryComparator lDAPEntryComparator, int n, int n2) {
        if (n >= n2) {
            return;
        }
        LDAPEntry lDAPEntry = lDAPEntryArray[n];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (lDAPEntryComparator.isGreater(lDAPEntryArray[--n4], lDAPEntry)) {
                continue;
            }
            while (lDAPEntryComparator.isGreater(lDAPEntry, lDAPEntryArray[++n3])) {
            }
            if (n3 >= n4) break;
            LDAPEntry lDAPEntry2 = lDAPEntryArray[n3];
            lDAPEntryArray[n3] = lDAPEntryArray[n4];
            lDAPEntryArray[n4] = lDAPEntry2;
        }
        this.quicksort(lDAPEntryArray, lDAPEntryComparator, n, n4);
        this.quicksort(lDAPEntryArray, lDAPEntryComparator, n4 + 1, n2);
    }

    public synchronized void sort(LDAPEntryComparator lDAPEntryComparator) {
        int n;
        while (!this.searchComplete) {
            this.fetchResult();
        }
        if (this.currCons.getReferrals()) {
            while (this.referralResults.size() > 0) {
                Object object = null;
                object = this.nextReferralElement();
                if (object == null) continue;
                this.entries.addElement(object);
            }
        }
        if ((n = this.entries.size()) <= 0) {
            return;
        }
        Object[] objectArray = new LDAPEntry[n];
        this.entries.copyInto(objectArray);
        if (objectArray.length > 1) {
            this.quicksort((LDAPEntry[])objectArray, lDAPEntryComparator, 0, n - 1);
        }
        this.entries.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            this.entries.addElement(objectArray[n2]);
            ++n2;
        }
    }

    public LDAPEntry next() throws LDAPException {
        Object object = this.nextElement();
        if (object instanceof LDAPReferralException || object instanceof LDAPException) {
            throw (LDAPException)object;
        }
        if (object instanceof LDAPEntry) {
            return (LDAPEntry)object;
        }
        return null;
    }

    public Object nextElement() {
        if (this.entries.size() > 0) {
            Object e = this.entries.elementAt(0);
            this.entries.removeElementAt(0);
            return e;
        }
        if (this.referralResults.size() > 0) {
            return this.nextReferralElement();
        }
        if (this.exceptions != null && this.exceptions.size() > 0) {
            Object e = this.exceptions.elementAt(0);
            this.exceptions.removeElementAt(0);
            return e;
        }
        return null;
    }

    Object nextReferralElement() {
        LDAPSearchResults lDAPSearchResults = (LDAPSearchResults)this.referralResults.elementAt(0);
        if (!lDAPSearchResults.persistentSearch && lDAPSearchResults.hasMoreElements() || lDAPSearchResults.persistentSearch) {
            Object object = lDAPSearchResults.nextElement();
            if (object != null) {
                return object;
            }
            if (object == null || !lDAPSearchResults.hasMoreElements()) {
                this.referralResults.removeElementAt(0);
            }
        } else {
            this.referralResults.removeElementAt(0);
        }
        return null;
    }

    public boolean hasMoreElements() {
        while (this.entries.size() == 0 && !this.searchComplete) {
            this.fetchResult();
        }
        if (this.entries.size() == 0 && (this.exceptions == null || this.exceptions.size() == 0)) {
            while (this.referralResults.size() > 0) {
                LDAPSearchResults lDAPSearchResults = (LDAPSearchResults)this.referralResults.elementAt(0);
                if (lDAPSearchResults.hasMoreElements()) {
                    return true;
                }
                this.referralResults.removeElementAt(0);
            }
        }
        return this.entries.size() > 0 || this.exceptions != null && this.exceptions.size() > 0;
    }

    public int getCount() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.referralResults.size()) {
            LDAPSearchResults lDAPSearchResults = (LDAPSearchResults)this.referralResults.elementAt(n3);
            n += lDAPSearchResults.getCount();
            ++n3;
        }
        if (this.resultSource != null) {
            n2 = this.resultSource.getCount();
        }
        if (this.exceptions != null) {
            return n2 + this.exceptions.size() + n;
        }
        return n2 + n;
    }

    int getID() {
        if (this.resultSource == null) {
            return -1;
        }
        return this.resultSource.getID();
    }

    void abandon() {
        LDAPSearchResults lDAPSearchResults = this;
        synchronized (lDAPSearchResults) {
            this.searchComplete = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void fetchResult() {
        if (this.resultSource == null) {
            return;
        }
        LDAPSearchResults lDAPSearchResults = this;
        synchronized (lDAPSearchResults) {
            if (this.searchComplete || this.firstResult) {
                this.firstResult = false;
                return;
            }
            JDAPMessage jDAPMessage = this.resultSource.nextResult();
            if (jDAPMessage == null) {
                try {
                    try {
                        JDAPMessage jDAPMessage2 = this.resultSource.getResponse();
                        this.currConn.checkSearchMsg(this, jDAPMessage2, this.currCons, this.currBase, this.currScope, this.currFilter, this.currAttrs, this.currAttrsOnly);
                    }
                    catch (LDAPException lDAPException) {
                        System.err.println("Exception: " + lDAPException);
                    }
                    Object var5_7 = null;
                    this.currConn.releaseSearchListener(this.resultSource);
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.currConn.releaseSearchListener(this.resultSource);
                    throw throwable;
                }
                this.searchComplete = true;
                if (this.connectionToClose == null) return;
                try {
                    this.connectionToClose.disconnect();
                }
                catch (LDAPException lDAPException) {}
            } else {
                try {
                    this.currConn.checkSearchMsg(this, jDAPMessage, this.currCons, this.currBase, this.currScope, this.currFilter, this.currAttrs, this.currAttrsOnly);
                }
                catch (LDAPException lDAPException) {
                    System.err.println("Exception: " + lDAPException);
                }
                return;
            }
            this.connectionToClose = null;
            return;
        }
    }
}

