/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.DragSession;
import netscape.application.Graphics;
import netscape.application.InternalWindow;
import netscape.application.MouseEvent;
import netscape.application.Timer;
import netscape.application.View;

class DragView
extends InternalWindow {
    int animationCount;
    int animationDeltaX;
    int animationDeltaY;
    boolean _animatingBack;
    boolean _wasAccepted;
    Timer timer;
    DragSession session;

    public DragView() {
    }

    public DragView(DragSession dragSession) {
        this.setBounds(dragSession.initialX, dragSession.initialY, dragSession.image.width(), dragSession.image.height());
        this.session = dragSession;
        this._lastX = dragSession.mouseDownX;
        this._lastY = dragSession.mouseDownY;
        this.setType(0);
        this.setTransparent(dragSession.image.isTransparent());
        this.contentView().setTransparent(true);
        this.setLayer(400);
        this.setRootView(dragSession.rootView);
        this.show();
        this.rootView().setMouseView(this);
        this.draw();
    }

    public void performCommand(String string, Object object) {
        if ("animateRejectedDrag".equals(string)) {
            this.animateRejectedDrag();
            return;
        }
        super.performCommand(string, object);
    }

    private void animateRejectedDrag() {
        if (this.animationCount <= 0) {
            this.timer.stop();
            this.timer = null;
            this._animatingBack = false;
            this.animationCount = 0;
            this.animationDeltaX = 0;
            this.animationDeltaY = 0;
            this.stopDragging();
            return;
        }
        --this.animationCount;
        int n = this._lastX - (this.animationDeltaX + this.bounds.x);
        int n2 = this._lastY - (this.animationDeltaY + this.bounds.y);
        MouseEvent mouseEvent = new MouseEvent(0L, -2, n, n2, 0);
        this.mouseDragged(mouseEvent);
    }

    void startAnimatingRejectedDrag() {
        this._animatingBack = true;
        if (this._lastX - this.session.mouseDownX != 0 && this._lastY - this.session.mouseDownY != 0) {
            int n;
            int n2;
            float f = this._lastX - this.session.mouseDownX;
            float f2 = this._lastY - this.session.mouseDownY;
            if (f > f2) {
                n2 = 1 + (int)(Math.abs(f2) / 5.0f);
                n = (int)(Math.abs(f2) / (float)n2);
                f /= Math.abs(f2);
                f2 = f2 < 0.0f ? -1.0f : 1.0f;
            } else if (f2 > f) {
                n2 = 1 + (int)(Math.abs(f) / 5.0f);
                n = (int)(Math.abs(f) / (float)n2);
                f2 /= Math.abs(f);
                f = f < 0.0f ? -1.0f : 1.0f;
            } else {
                n = 0;
                n2 = 0;
            }
            if (n > 0) {
                this.animationCount = n;
                this.animationDeltaX = (int)((float)n2 * f);
                this.animationDeltaY = (int)((float)n2 * f2);
                this.timer = new Timer(this, "animateRejectedDrag", 25);
                this.timer.start();
                return;
            }
            this._animatingBack = false;
            this.stopDragging();
            return;
        }
        this._animatingBack = false;
        this.stopDragging();
    }

    public boolean canBecomeMain() {
        return false;
    }

    public boolean canBecomeDocument() {
        return false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (!this._animatingBack) {
            this.session.mouseDragged(mouseEvent);
        }
    }

    void stopDragging() {
        if (!this.isVisible()) {
            return;
        }
        this.hide();
        this.setBuffered(false);
        this.rootView.redraw(this.bounds);
    }

    public void mouseUp(MouseEvent mouseEvent) {
        super.mouseUp(mouseEvent);
        this.session.mouseUp(mouseEvent);
    }

    public void drawView(Graphics graphics) {
        this.session.image.drawAt(graphics, 0, 0);
    }

    public View viewForMouse(int n, int n2) {
        return null;
    }
}

