/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.EventDispatchThread;
import java.awt.EventQueueItem;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.util.Hashtable;

public class EventQueue {
    private static int threadInitNumber;
    private static Hashtable eventQueuesTable;
    private EventDispatchThread dispatchThread;
    private EventQueueItem queue = null;

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    public EventQueue() {
        String string = "AWT-EventQueue-" + EventQueue.nextThreadNum();
        this.dispatchThread = new EventDispatchThread(string, this);
        EventQueue.putQueue(this.dispatchThread.getThreadGroup(), this);
        this.dispatchThread.start();
    }

    public EventQueue(Thread thread) {
        EventQueue.putQueue(thread.getThreadGroup(), this);
    }

    public static void putQueue(ThreadGroup threadGroup, EventQueue eventQueue) {
        if (eventQueuesTable == null) {
            eventQueuesTable = new Hashtable();
        }
        eventQueuesTable.put(threadGroup, eventQueue);
    }

    public static EventQueue getQueue(ThreadGroup threadGroup) {
        if (eventQueuesTable == null) {
            return null;
        }
        if (threadGroup != null) {
            Object object = eventQueuesTable.get(threadGroup);
            if (object != null) {
                return (EventQueue)object;
            }
            return EventQueue.getQueue(threadGroup.getParent());
        }
        return null;
    }

    public static void removeQueue(ThreadGroup threadGroup) {
        if (eventQueuesTable == null) {
            return;
        }
        EventQueue eventQueue = EventQueue.getQueue(threadGroup);
        if (eventQueue != null) {
            if (eventQueue.dispatchThread != null) {
                eventQueue.dispatchThread.stopDispatching();
            }
            eventQueuesTable.remove(threadGroup);
        }
    }

    public static void clearQueuesTable() {
        if (eventQueuesTable == null) {
            return;
        }
        eventQueuesTable.clear();
    }

    public synchronized void postEvent(AWTEvent aWTEvent) {
        EventQueueItem eventQueueItem = new EventQueueItem(aWTEvent);
        if (this.queue == null) {
            this.queue = eventQueueItem;
            this.notifyAll();
            return;
        }
        EventQueueItem eventQueueItem2 = this.queue;
        while (true) {
            if (eventQueueItem2.id == eventQueueItem.id) {
                switch (eventQueueItem2.id) {
                    case 503: 
                    case 506: {
                        MouseEvent mouseEvent = (MouseEvent)eventQueueItem2.event;
                        if (mouseEvent.getSource() != ((MouseEvent)aWTEvent).getSource() || mouseEvent.getModifiers() != ((MouseEvent)aWTEvent).getModifiers()) break;
                        eventQueueItem2.event = eventQueueItem.event;
                        return;
                    }
                    case 800: 
                    case 801: {
                        Rectangle rectangle;
                        PaintEvent paintEvent = (PaintEvent)eventQueueItem2.event;
                        if (paintEvent.getSource() != aWTEvent.getSource()) break;
                        Rectangle rectangle2 = paintEvent.getUpdateRect();
                        if (!rectangle2.equals(rectangle = ((PaintEvent)aWTEvent).getUpdateRect())) {
                            paintEvent.setUpdateRect(rectangle2.union(rectangle));
                        }
                        return;
                    }
                }
            }
            if (eventQueueItem2.next == null) break;
            eventQueueItem2 = eventQueueItem2.next;
        }
        eventQueueItem2.next = eventQueueItem;
    }

    public synchronized AWTEvent getNextEvent() throws InterruptedException {
        while (this.queue == null) {
            this.wait();
        }
        EventQueueItem eventQueueItem = this.queue;
        this.queue = this.queue.next;
        return eventQueueItem.event;
    }

    public synchronized AWTEvent peekEvent() {
        if (this.queue != null) {
            return this.queue.event;
        }
        return null;
    }

    public synchronized AWTEvent peekEvent(int n) {
        EventQueueItem eventQueueItem = this.queue;
        while (eventQueueItem != null) {
            if (eventQueueItem.id == n) {
                return eventQueueItem.event;
            }
            eventQueueItem = eventQueueItem.next;
        }
        return null;
    }

    synchronized void changeKeyEventFocus(Object object) {
        EventQueueItem eventQueueItem = this.queue;
        while (eventQueueItem != null) {
            if (eventQueueItem.event instanceof KeyEvent) {
                eventQueueItem.event.setSource(object);
            }
            eventQueueItem = eventQueueItem.next;
        }
    }

    synchronized void removeSourceEvents(Object object) {
        EventQueueItem eventQueueItem = this.queue;
        EventQueueItem eventQueueItem2 = null;
        while (eventQueueItem != null) {
            if (eventQueueItem.event.getSource().equals(object)) {
                if (eventQueueItem2 == null) {
                    this.queue = eventQueueItem.next;
                } else {
                    eventQueueItem2.next = eventQueueItem.next;
                }
            }
            eventQueueItem2 = eventQueueItem;
            eventQueueItem = eventQueueItem.next;
        }
    }

    static {
        eventQueuesTable = null;
    }
}

