/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.io.InputStream;
import sun.audio.AudioDevice;

public class AudioPlayer
extends Thread {
    private AudioDevice devAudio = AudioDevice.device;
    public static final AudioPlayer player = AudioPlayer.CreateAudioPlayer();

    private static AudioPlayer CreateAudioPlayer() {
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        SecurityManager.enablePrivilege("UniversalThreadGroupAccess");
        return new AudioPlayer();
    }

    private static ThreadGroup getAudioThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    private AudioPlayer() {
        super(AudioPlayer.getAudioThreadGroup(), "Audio Player");
        this.setPriority(10);
        this.setDaemon(true);
        this.start();
    }

    public synchronized void start(InputStream inputStream) {
        this.devAudio.openChannel(inputStream);
        this.notify();
    }

    public synchronized void stop(InputStream inputStream) {
        this.devAudio.closeChannel(inputStream);
    }

    public void run() {
        this.devAudio.open();
        this.devAudio.play();
        this.devAudio.close();
        System.out.println("audio player exit");
    }
}

