/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.CORBA.dynamic;

import com.visigenic.vbroker.CORBA.GiopInputStream;
import com.visigenic.vbroker.CORBA.GiopOutputStream;
import com.visigenic.vbroker.CORBA.ORB;
import com.visigenic.vbroker.CORBA.OrbObject;
import com.visigenic.vbroker.CORBA.TypeCode;
import java.util.Dictionary;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TCKindHelper;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class TypeCodeImpl
extends TypeCode
implements OrbObject {
    private ORB _orb;
    private TCKind _kind;
    private String _id;
    private Any[] _parameters;
    private int _default_index;
    private boolean _backwardCompatible;
    private static String[] _tkNames = new String[]{"null", "void", "short", "long", "unsigned short", "unsigned long", "float", "double", "boolean", "char", "octet", "any", "TypeCode", "Principal", "Object", "struct", "union", "enum", "string", "sequence", "array", "alias", "except", "long long", "unsigned long long", "long double", "wchar", "wstring"};

    public void init(ORB oRB, Object[] objectArray) {
        this._orb = oRB;
        this._backwardCompatible = this._orb.backwardCompatible;
    }

    public TypeCode init_primitive(TCKind tCKind) {
        switch (tCKind.value()) {
            default: {
                throw new BAD_PARAM();
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
        }
        this._kind = tCKind;
        return this;
    }

    public TypeCode init_struct(String string, String string2, StructMember[] structMemberArray) {
        return this.init_shared(TCKind.tk_struct, string, string2, null, structMemberArray);
    }

    public TypeCode init_estruct(String string, String string2, org.omg.CORBA.TypeCode typeCode, StructMember[] structMemberArray) {
        return this.init_shared(TCKind.tk_estruct, string, string2, typeCode, structMemberArray);
    }

    public TypeCode init_except(String string, String string2, StructMember[] structMemberArray) {
        return this.init_shared(TCKind.tk_except, string, string2, null, structMemberArray);
    }

    private TypeCode init_shared(TCKind tCKind, String string, String string2, org.omg.CORBA.TypeCode typeCode, StructMember[] structMemberArray) {
        this._kind = tCKind;
        this._id = string;
        this._parameters = tCKind == TCKind.tk_estruct ? new Any[structMemberArray.length * 2 + 2] : new Any[structMemberArray.length * 2 + 1];
        int n = 0;
        this._parameters[n] = this._orb.create_any();
        this._parameters[n].insert_string(string2);
        ++n;
        if (tCKind == TCKind.tk_estruct) {
            this._parameters[n] = this._orb.create_any();
            this._parameters[n].insert_TypeCode(typeCode);
            ++n;
        }
        int n2 = 0;
        while (n2 < structMemberArray.length) {
            this._parameters[n] = this._orb.create_any();
            this._parameters[n].insert_string(structMemberArray[n2].name);
            this._parameters[++n] = this._orb.create_any();
            this._parameters[n].insert_TypeCode(structMemberArray[n2].type);
            ++n;
            ++n2;
        }
        return this;
    }

    public TypeCode init_union(String string, String string2, org.omg.CORBA.TypeCode typeCode, UnionMember[] unionMemberArray) {
        this._kind = TCKind.tk_union;
        this._id = string;
        this._parameters = new Any[unionMemberArray.length * 3 + 2];
        this._default_index = -1;
        int n = 0;
        this._parameters[n] = this._orb.create_any();
        this._parameters[n].insert_string(string2);
        this._parameters[++n] = this._orb.create_any();
        this._parameters[n].insert_TypeCode(typeCode);
        ++n;
        int n2 = 0;
        while (n2 < unionMemberArray.length) {
            if (unionMemberArray[n2].label.type().kind() == TCKind.tk_octet) {
                this._default_index = n2;
            }
            this._parameters[n] = unionMemberArray[n2].label;
            this._parameters[++n] = this._orb.create_any();
            this._parameters[n].insert_string(unionMemberArray[n2].name);
            this._parameters[++n] = this._orb.create_any();
            this._parameters[n].insert_TypeCode(unionMemberArray[n2].type);
            ++n;
            ++n2;
        }
        return this;
    }

    public TypeCode init_enum(String string, String string2, String[] stringArray) {
        this._kind = TCKind.tk_enum;
        this._id = string;
        this._parameters = new Any[stringArray.length + 1];
        int n = 0;
        this._parameters[n] = this._orb.create_any();
        this._parameters[n].insert_string(string2);
        ++n;
        int n2 = 0;
        while (n2 < stringArray.length) {
            this._parameters[n] = this._orb.create_any();
            this._parameters[n].insert_string(stringArray[n2]);
            ++n;
            ++n2;
        }
        return this;
    }

    public TypeCode init_alias(String string, String string2, org.omg.CORBA.TypeCode typeCode) {
        this._kind = TCKind.tk_alias;
        this._id = string;
        this._parameters = new Any[2];
        this._parameters[0] = this._orb.create_any();
        this._parameters[0].insert_string(string2);
        this._parameters[1] = this._orb.create_any();
        this._parameters[1].insert_TypeCode(typeCode);
        return this;
    }

    public TypeCode init_interface(String string, String string2) {
        this._kind = TCKind.tk_objref;
        this._id = string;
        this._parameters = new Any[1];
        this._parameters[0] = this._orb.create_any();
        this._parameters[0].insert_string(string2);
        return this;
    }

    public TypeCode init_string(int n) {
        this._kind = TCKind.tk_string;
        this._parameters = new Any[1];
        this._parameters[0] = this._orb.create_any();
        this._parameters[0].insert_ulong(n);
        return this;
    }

    public TypeCode init_wstring(int n) {
        this._kind = TCKind.tk_wstring;
        this._parameters = new Any[1];
        this._parameters[0] = this._orb.create_any();
        this._parameters[0].insert_ulong(n);
        return this;
    }

    public TypeCode init_sequence(org.omg.CORBA.TypeCode typeCode, int n) {
        return this.init_sequence_or_array(TCKind.tk_sequence, typeCode, n);
    }

    public TypeCode init_array(org.omg.CORBA.TypeCode typeCode, int n) {
        return this.init_sequence_or_array(TCKind.tk_array, typeCode, n);
    }

    private TypeCode init_sequence_or_array(TCKind tCKind, org.omg.CORBA.TypeCode typeCode, int n) {
        this._kind = tCKind;
        this._parameters = new Any[2];
        this._parameters[0] = this._orb.create_any();
        this._parameters[0].insert_TypeCode(typeCode);
        this._parameters[1] = this._orb.create_any();
        this._parameters[1].insert_ulong(n);
        return this;
    }

    private boolean requiresEncapsulation(int n) {
        if (this._backwardCompatible) {
            return false;
        }
        switch (n) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public TypeCode read(InputStream inputStream) {
        GiopInputStream giopInputStream = (GiopInputStream)inputStream;
        int n = giopInputStream.offset();
        Dictionary dictionary = giopInputStream.typeCodes();
        int n2 = giopInputStream.read_long();
        if (n2 != -1) {
            this._kind = TCKind.from_int(n2);
        }
        if (this.requiresEncapsulation(n2)) {
            giopInputStream = this._orb.newGiopInputStream(giopInputStream.readByteArray(giopInputStream.read_long()));
            giopInputStream.byteOrder(giopInputStream.read_boolean());
        }
        switch (n2) {
            case 14: {
                this.init_interface(giopInputStream.read_string(), giopInputStream.read_string());
                break;
            }
            case 15: 
            case 22: 
            case 32: {
                String string = giopInputStream.read_string();
                String string2 = giopInputStream.read_string();
                TypeCode typeCode = null;
                if (this._kind == TCKind.tk_estruct) {
                    typeCode = this._orb.create_tc().read(giopInputStream);
                }
                int n3 = giopInputStream.read_long();
                StructMember[] structMemberArray = new StructMember[n3];
                int n4 = 0;
                while (n4 < n3) {
                    structMemberArray[n4] = new StructMember(giopInputStream.read_string(), this._orb.create_tc().read(giopInputStream), null);
                    ++n4;
                }
                this.init_shared(this._kind, string, string2, typeCode, structMemberArray);
                break;
            }
            case 16: {
                String string = giopInputStream.read_string();
                String string3 = giopInputStream.read_string();
                TypeCode typeCode = this._orb.create_tc().read(giopInputStream);
                int n5 = giopInputStream.read_long();
                int n6 = giopInputStream.read_long();
                UnionMember[] unionMemberArray = new UnionMember[n6];
                int n7 = 0;
                while (n7 < n6) {
                    Any any;
                    if (n7 == n5) {
                        any = this._orb.create_any();
                        any.insert_octet(giopInputStream.read_octet());
                    } else {
                        any = this._orb.create_any();
                        any.read_value(giopInputStream, typeCode);
                    }
                    String string4 = giopInputStream.read_string();
                    TypeCode typeCode2 = this._orb.create_tc().read(giopInputStream);
                    unionMemberArray[n7] = new UnionMember(string4, any, typeCode2, null);
                    ++n7;
                }
                this.init_union(string, string3, typeCode, unionMemberArray);
                break;
            }
            case 17: {
                String string = giopInputStream.read_string();
                String string5 = giopInputStream.read_string();
                int n8 = giopInputStream.read_long();
                String[] stringArray = new String[n8];
                int n9 = 0;
                while (n9 < n8) {
                    stringArray[n9] = giopInputStream.read_string();
                    ++n9;
                }
                this.init_enum(string, string5, stringArray);
                break;
            }
            case 18: {
                this.init_string(giopInputStream.read_long());
                break;
            }
            case 27: {
                this.init_wstring(giopInputStream.read_long());
                break;
            }
            case 19: 
            case 20: {
                this.init_sequence_or_array(this._kind, this._orb.create_tc().read(giopInputStream), giopInputStream.read_long());
                break;
            }
            case 21: {
                this.init_alias(giopInputStream.read_string(), giopInputStream.read_string(), this._orb.create_tc().read(giopInputStream));
                break;
            }
            case -1: {
                int n10 = giopInputStream.read_long();
                n = giopInputStream.offset();
                TypeCodeImpl typeCodeImpl = (TypeCodeImpl)dictionary.get(new Integer(n + n10));
                if (typeCodeImpl == null) {
                    throw new MARSHAL("Invalid TypeCode offset: " + n10 + "/" + n);
                }
                this._kind = typeCodeImpl._kind;
                this._id = typeCodeImpl._id;
                this._parameters = typeCodeImpl._parameters;
                this._default_index = typeCodeImpl._default_index;
                break;
            }
            default: {
                throw new MARSHAL("Invalid TypeCode kind: " + this._kind);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
        }
        dictionary.put(new Integer(n), this);
        return this;
    }

    public void write(OutputStream outputStream) {
        block18: {
            GiopOutputStream giopOutputStream = (GiopOutputStream)outputStream;
            TCKindHelper.write(giopOutputStream, this._kind);
            GiopOutputStream giopOutputStream2 = null;
            if (this.requiresEncapsulation(this._kind.value())) {
                giopOutputStream2 = giopOutputStream;
                giopOutputStream = this._orb.newGiopOutputStream();
                giopOutputStream.write_boolean(giopOutputStream.byteOrder());
            }
            try {
                switch (this._kind.value()) {
                    case 14: {
                        giopOutputStream.write_string(this.id());
                        giopOutputStream.write_string(this.name());
                        break;
                    }
                    case 15: 
                    case 22: 
                    case 32: {
                        giopOutputStream.write_string(this.id());
                        giopOutputStream.write_string(this.name());
                        if (this._kind == TCKind.tk_estruct) {
                            giopOutputStream.write_TypeCode(this.base_type());
                        }
                        int n = this.member_count();
                        giopOutputStream.write_long(n);
                        int n2 = 0;
                        while (n2 < n) {
                            giopOutputStream.write_string(this.member_name(n2));
                            giopOutputStream.write_TypeCode(this.member_type(n2));
                            ++n2;
                        }
                        break;
                    }
                    case 16: {
                        giopOutputStream.write_string(this.id());
                        giopOutputStream.write_string(this.name());
                        giopOutputStream.write_TypeCode(this.discriminator_type());
                        giopOutputStream.write_long(this.default_index());
                        int n = this.member_count();
                        giopOutputStream.write_long(n);
                        int n3 = 0;
                        while (n3 < n) {
                            this.member_label(n3).write_value(giopOutputStream);
                            giopOutputStream.write_string(this.member_name(n3));
                            giopOutputStream.write_TypeCode(this.member_type(n3));
                            ++n3;
                        }
                        break;
                    }
                    case 17: {
                        giopOutputStream.write_string(this.id());
                        giopOutputStream.write_string(this.name());
                        int n = this.member_count();
                        giopOutputStream.write_long(n);
                        int n4 = 0;
                        while (n4 < n) {
                            giopOutputStream.write_string(this.member_name(n4));
                            ++n4;
                        }
                        break;
                    }
                    case 18: 
                    case 27: {
                        giopOutputStream.write_long(this.length());
                        break;
                    }
                    case 19: 
                    case 20: {
                        giopOutputStream.write_TypeCode(this.content_type());
                        giopOutputStream.write_long(this.length());
                        break;
                    }
                    case 21: {
                        giopOutputStream.write_string(this.id());
                        giopOutputStream.write_string(this.name());
                        giopOutputStream.write_TypeCode(this.content_type());
                        break;
                    }
                    default: {
                        if (!this.requiresEncapsulation(this._kind.value())) break block18;
                    }
                }
            }
            catch (UserException userException) {
                throw new INTERNAL(userException.toString());
            }
            if (!this.requiresEncapsulation(this._kind.value())) break block18;
            giopOutputStream2.write_long(giopOutputStream.offset());
            giopOutputStream2.write_octet_array(giopOutputStream.toByteArray(), 0, giopOutputStream.offset());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof org.omg.CORBA.TypeCode)) {
            return false;
        }
        try {
            return this.equal((org.omg.CORBA.TypeCode)object);
        }
        catch (SystemException systemException) {
            return false;
        }
    }

    public boolean equal(org.omg.CORBA.TypeCode typeCode) {
        try {
            if (this == typeCode) {
                return true;
            }
            if (typeCode == null) {
                return false;
            }
            if (this.kind() == TCKind.tk_alias) {
                return this.content_type().equal(typeCode);
            }
            if (typeCode.kind() == TCKind.tk_alias) {
                return this.equal(typeCode.content_type());
            }
            if (this.kind() != typeCode.kind()) {
                return false;
            }
            if (!(typeCode instanceof TypeCodeImpl)) {
                throw new BAD_PARAM("Incompatible typecode: " + typeCode);
            }
            TypeCodeImpl typeCodeImpl = (TypeCodeImpl)typeCode;
            if (this._parameters == null) {
                return true;
            }
            if (this._parameters.length != typeCodeImpl.param_count()) {
                return false;
            }
            int n = 0;
            while (n < this._parameters.length) {
                if (!this._parameters[n].equal(typeCodeImpl.parameter(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (UserException userException) {
            throw new INTERNAL(userException.toString());
        }
    }

    public TCKind kind() {
        return this._kind;
    }

    public String id() throws BadKind {
        switch (this._kind.value()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 32: {
                return this._id;
            }
        }
        throw new BadKind();
    }

    public String name() throws BadKind {
        switch (this._kind.value()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 32: {
                return this._parameters[0].extract_string();
            }
        }
        throw new BadKind();
    }

    public int member_count() throws BadKind {
        switch (this._kind.value()) {
            case 15: 
            case 22: {
                return (this._parameters.length - 1) / 2;
            }
            case 32: {
                return (this._parameters.length - 2) / 2;
            }
            case 16: {
                return (this._parameters.length - 2) / 3;
            }
            case 17: {
                return this._parameters.length - 1;
            }
        }
        throw new BadKind();
    }

    public String member_name(int n) throws BadKind, Bounds {
        if (n < 0) {
            throw new Bounds();
        }
        switch (this._kind.value()) {
            case 15: 
            case 22: {
                return this.parameter(n * 2 + 1).extract_string();
            }
            case 32: {
                return this.parameter(n * 2 + 2).extract_string();
            }
            case 16: {
                return this.parameter(n * 3 + 3).extract_string();
            }
            case 17: {
                return this.parameter(n + 1).extract_string();
            }
        }
        throw new BadKind();
    }

    public org.omg.CORBA.TypeCode member_type(int n) throws BadKind, Bounds {
        if (n < 0) {
            throw new Bounds();
        }
        switch (this._kind.value()) {
            case 15: 
            case 22: {
                return this.parameter(n * 2 + 2).extract_TypeCode();
            }
            case 32: {
                return this.parameter(n * 2 + 3).extract_TypeCode();
            }
            case 16: {
                return this.parameter(n * 3 + 4).extract_TypeCode();
            }
        }
        throw new BadKind();
    }

    public org.omg.CORBA.TypeCode base_type() throws BadKind {
        if (this._kind != TCKind.tk_estruct) {
            throw new BadKind();
        }
        return this._parameters[1].extract_TypeCode();
    }

    public Any member_label(int n) throws BadKind, Bounds {
        if (n < 0) {
            throw new Bounds();
        }
        if (this._kind != TCKind.tk_union) {
            throw new BadKind();
        }
        return this.parameter(n * 3 + 2);
    }

    public org.omg.CORBA.TypeCode discriminator_type() throws BadKind {
        if (this._kind != TCKind.tk_union) {
            throw new BadKind();
        }
        return this._parameters[1].extract_TypeCode();
    }

    public int default_index() throws BadKind {
        if (this._kind != TCKind.tk_union) {
            throw new BadKind();
        }
        return this._default_index;
    }

    public int length() throws BadKind {
        switch (this._kind.value()) {
            case 19: 
            case 20: {
                return this._parameters[1].extract_ulong();
            }
            case 18: 
            case 27: {
                return this._parameters[0].extract_ulong();
            }
        }
        throw new BadKind();
    }

    public org.omg.CORBA.TypeCode content_type() throws BadKind {
        switch (this._kind.value()) {
            case 19: 
            case 20: {
                return this._parameters[0].extract_TypeCode();
            }
            case 21: {
                return this._parameters[1].extract_TypeCode();
            }
        }
        throw new BadKind();
    }

    public int param_count() {
        if (this._parameters == null) {
            return 0;
        }
        return this._parameters.length;
    }

    public Any parameter(int n) throws Bounds {
        if (this._parameters == null || n < 0 || n >= this._parameters.length) {
            throw new Bounds();
        }
        return this._parameters[n];
    }

    public String typeCodeName() {
        int n = this._kind.value();
        if (n >= 0 && n <= 27) {
            return _tkNames[n];
        }
        if (this._kind == TCKind.tk_estruct) {
            return "estruct";
        }
        return "<invalid>";
    }

    public String toString() {
        try {
            switch (this._kind.value()) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 21: 
                case 22: 
                case 32: {
                    return this.name();
                }
                case 18: 
                case 27: {
                    if (this.length() == 0) {
                        return _tkNames[this._kind.value()];
                    }
                    return String.valueOf(_tkNames[this._kind.value()]) + "<" + this.length() + ">";
                }
                case 19: {
                    if (this.length() == 0) {
                        return "sequence<" + this.content_type() + ">";
                    }
                    return "sequence<" + this.content_type() + "," + this.length() + ">";
                }
                case 20: {
                    return String.valueOf(this.content_type()) + "[" + this.length() + "]";
                }
            }
            return this.typeCodeName();
        }
        catch (UserException userException) {
            return "org.omg.CORBA.TypeCode[<<<" + userException + ">>>]";
        }
    }

    private String toFullString() {
        String string = "org.omg.CORBA.TypeCode[kind=" + this.typeCodeName();
        if (this._id != null) {
            string = String.valueOf(string) + ",id=" + this._id;
        }
        try {
            switch (this._kind.value()) {
                case 15: 
                case 22: 
                case 32: {
                    string = String.valueOf(string) + ",name=" + this.name();
                    if (this._kind == TCKind.tk_estruct) {
                        string = String.valueOf(string) + ",base_type=" + this.base_type();
                    }
                    int n = 0;
                    while (n < this.member_count()) {
                        string = String.valueOf(string) + ",[name=" + this.member_name(n);
                        string = String.valueOf(string) + ",type=" + this.member_type(n) + "]";
                        ++n;
                    }
                    break;
                }
                case 16: {
                    string = String.valueOf(string) + ",name=" + this.name();
                    string = String.valueOf(string) + ",discriminator_type=" + this.discriminator_type();
                    string = String.valueOf(string) + ",default_index=" + this.default_index();
                    int n = 0;
                    while (n < this.member_count()) {
                        string = String.valueOf(string) + ",[label=" + this.member_label(n);
                        string = String.valueOf(string) + ",name=" + this.member_name(n);
                        string = String.valueOf(string) + ",type=" + this.member_type(n) + "]";
                        ++n;
                    }
                    break;
                }
                case 17: {
                    string = String.valueOf(string) + ",name=" + this.name();
                    int n = 0;
                    while (n < this.member_count()) {
                        string = String.valueOf(string) + "," + this.member_name(n);
                        ++n;
                    }
                    break;
                }
                case 21: {
                    string = String.valueOf(string) + ",name=" + this.name();
                    string = String.valueOf(string) + ",type=" + this.content_type();
                    break;
                }
                case 14: {
                    string = String.valueOf(string) + ",name=" + this.name();
                    break;
                }
                case 18: 
                case 27: {
                    string = String.valueOf(string) + ",length=" + this.length();
                    break;
                }
                case 19: 
                case 20: {
                    string = String.valueOf(string) + ",type=" + this.content_type() + ",length=" + this.length();
                    break;
                }
                default: {
                    int n = 0;
                    while (n < this.param_count()) {
                        string = String.valueOf(string) + ",param[" + n + "]=" + this.parameter(n);
                        ++n;
                    }
                    break;
                }
            }
        }
        catch (UserException userException) {
            string = String.valueOf(string) + "<<<" + userException + ">>>";
        }
        return String.valueOf(string) + "]";
    }
}

