/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.RMIThread;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.Utils;
import sun.rmi.transport.tcp.Pinger;
import sun.rmi.transport.tcp.TCPTransport;

public class TCPEndpoint
implements Endpoint,
Serializable {
    private String host;
    private int port;
    private static Hashtable transportTable = new Hashtable(2);
    private static Pinger pinger;
    private static String localHost;
    private static boolean localHostKnown;
    private static TCPEndpoint defaultEndpoint;

    public TCPEndpoint(String string, int n) {
        System.getSecurityManager().checkConnect(string, n);
        if (string == null) {
            string = "";
        }
        this.host = string;
        this.port = n;
    }

    public void checkConnect() {
        System.getSecurityManager().checkConnect(this.host, this.port);
    }

    public static TCPEndpoint getLocalEndpoint(int n) {
        SecurityManager.enablePrivilege((String)"UniversalConnect");
        if (n == 0) {
            return defaultEndpoint;
        }
        return new TCPEndpoint(localHost, n);
    }

    static void setLocalHost(String string) {
        if (!localHostKnown) {
            TCPEndpoint.defaultEndpoint.host = string;
            localHost = string;
            localHostKnown = true;
            if (TCPTransport.logLevel >= 10) {
                LogStream.log("tcp").println("TCPEndpoint.setLocalHost: set local host to " + string);
            }
        }
    }

    static void setDefaultPort(int n) {
        if (TCPEndpoint.defaultEndpoint.port != 0) {
            return;
        }
        Hashtable hashtable = transportTable;
        synchronized (hashtable) {
            Integer n2 = new Integer(TCPEndpoint.defaultEndpoint.port);
            Transport transport = (Transport)transportTable.get(n2);
            if (transport != null) {
                transportTable.remove(n2);
                transportTable.put(new Integer(n), transport);
            }
            TCPEndpoint.defaultEndpoint.port = n;
            if (TCPTransport.logLevel >= 10) {
                LogStream.log("tcp").println("TCPEndpoint.setDefaultPort: set default port to " + n);
            }
            return;
        }
    }

    public Transport getTransport() {
        return this.getTransport(false);
    }

    private Transport getTransport(boolean bl) {
        Transport transport = null;
        Hashtable hashtable = transportTable;
        synchronized (hashtable) {
            if (bl) {
                Integer n = new Integer(this.port);
                transport = (Transport)transportTable.get(n);
                if (transport == null) {
                    transport = new TCPTransport(this.port);
                    transportTable.put(n, transport);
                }
            } else {
                System.getSecurityManager().checkConnect(this.host, TCPTransport.DefaultPort);
                Integer n = new Integer(TCPTransport.DefaultPort);
                transport = (Transport)transportTable.get(n);
                if (transport == null) {
                    transport = defaultEndpoint.getTransport(true);
                }
            }
        }
        return transport;
    }

    public void exportObject(ObjID objID, Target target) throws RemoteException {
        Transport transport = this.getTransport(true);
        transport.exportObject(objID, target);
        Hashtable hashtable = transportTable;
        synchronized (hashtable) {
            if (pinger == null) {
                pinger = new Pinger();
                Thread thread = RMIThread.newThread(pinger, "Pinger", true);
                thread.start();
            }
            return;
        }
    }

    public Channel getChannel() {
        Transport transport = this.getTransport(false);
        return transport.getChannel(this);
    }

    public final String getHost() {
        if (this.host == null) {
            return null;
        }
        return new String(this.host);
    }

    public final int getPort() {
        return this.port;
    }

    public String toString() {
        return "[" + this.host + ":" + this.port + "]";
    }

    public int hashCode() {
        return this.port;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TCPEndpoint) {
            TCPEndpoint tCPEndpoint = (TCPEndpoint)object;
            return this.port == tCPEndpoint.port && this.host.equals(tCPEndpoint.host);
        }
        return false;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.host);
        dataOutput.writeInt(this.port);
    }

    public static TCPEndpoint read(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        int n = dataInput.readInt();
        return new TCPEndpoint(string, n);
    }

    static void ping() {
        Enumeration enumeration = transportTable.elements();
        while (enumeration.hasMoreElements()) {
            TCPTransport tCPTransport = (TCPTransport)enumeration.nextElement();
            tCPTransport.ping();
        }
    }

    static {
        localHostKnown = true;
        SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
        localHost = Utils.getProperty("java.rmi.server.hostname");
        SecurityManager.revertPrivilege();
        if (localHost == null) {
            try {
                if (Utils.getLong("sun.rmi.transport.tcp.simulateApplet", 0L).intValue() >= 1) {
                    InetAddress inetAddress = InetAddress.getByName("");
                } else {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    byte[] byArray = inetAddress.getAddress();
                    if (byArray[0] == 127 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 1) {
                        localHostKnown = false;
                    }
                    localHost = inetAddress.getHostName();
                }
            }
            catch (Exception exception) {
                localHostKnown = false;
                localHost = null;
            }
        }
        SecurityManager.enablePrivilege((String)"UniversalConnect");
        defaultEndpoint = new TCPEndpoint(localHost, 0);
        SecurityManager.revertPrivilege();
        if (TCPTransport.logLevel >= 10) {
            LogStream.log("tcp").println("TCPEndpoint.<clinit>: localHostKnown = " + localHostKnown + ", localHost = " + localHost);
        }
    }
}

