/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ListPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class List
extends Component
implements ItemSelectable {
    Vector items = new Vector();
    int rows;
    boolean multipleMode = false;
    int[] selected = new int[0];
    int visibleIndex = -1;
    transient ActionListener actionListener;
    transient ItemListener itemListener;
    private static final String base = "list";
    private static int nameCounter;
    private static final long serialVersionUID = -3304312411574666869L;
    static final int DEFAULT_VISIBLE_ROWS = 4;
    private int listSerializedDataVersion = 1;

    public List() {
        this(0, false);
    }

    public List(int n) {
        this(n, false);
    }

    public List(int n, boolean bl) {
        this.name = base + nameCounter++;
        this.rows = n != 0 ? n : 4;
        this.multipleMode = bl;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createList(this);
        }
        super.addNotify();
        List list = this;
        synchronized (list) {
            this.visibleIndex = -1;
            return;
        }
    }

    public void removeNotify() {
        List list = this;
        synchronized (list) {
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                this.selected = listPeer.getSelectedIndexes();
            }
        }
        super.removeNotify();
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.items.size();
    }

    public String getItem(int n) {
        return (String)this.items.elementAt(n);
    }

    public synchronized String[] getItems() {
        Object[] objectArray = new String[this.items.size()];
        this.items.copyInto(objectArray);
        return objectArray;
    }

    public void add(String string) {
        this.addItem(string);
    }

    public void addItem(String string) {
        this.addItem(string, -1);
    }

    public synchronized void add(String string, int n) {
        this.addItem(string, n);
    }

    public synchronized void addItem(String string, int n) {
        if (n < -1 || n >= this.items.size()) {
            n = -1;
        }
        if (n == -1) {
            this.items.addElement(string);
        } else {
            this.items.insertElementAt(string, n);
        }
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.addItem(string, n);
        }
    }

    public synchronized void replaceItem(String string, int n) {
        this.remove(n);
        this.add(string, n);
    }

    public synchronized void removeAll() {
        this.clear();
    }

    public synchronized void clear() {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.clear();
        }
        this.items = new Vector();
        this.selected = new int[0];
    }

    public synchronized void remove(String string) {
        int n = this.items.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("item " + string + " not found in list");
        }
        this.remove(n);
    }

    public synchronized void remove(int n) {
        this.delItem(n);
    }

    public synchronized void delItem(int n) {
        this.delItems(n, n);
    }

    public synchronized int getSelectedIndex() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray.length == 1) {
            return nArray[0];
        }
        return -1;
    }

    public synchronized int[] getSelectedIndexes() {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            this.selected = listPeer.getSelectedIndexes();
        }
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.getItem(n);
    }

    public synchronized String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.getItem(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public void select(int n) {
        ListPeer listPeer;
        do {
            if ((listPeer = (ListPeer)this.peer) != null) {
                listPeer.select(n);
                return;
            }
            List list = this;
            synchronized (list) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < this.selected.length) {
                    if (this.selected[n2] == n) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    if (!this.multipleMode) {
                        this.selected = new int[1];
                        this.selected[0] = n;
                    } else {
                        int[] nArray = new int[this.selected.length + 1];
                        System.arraycopy(this.selected, 0, nArray, 0, this.selected.length);
                        nArray[this.selected.length] = n;
                        this.selected = nArray;
                    }
                }
            }
        } while (listPeer != this.peer);
    }

    public synchronized void deselect(int n) {
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.deselect(n);
        }
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] == n) {
                int[] nArray = new int[this.selected.length - 1];
                System.arraycopy(this.selected, 0, nArray, 0, n2);
                System.arraycopy(this.selected, n2 + 1, nArray, n2, this.selected.length - (n2 + 1));
                this.selected = nArray;
                return;
            }
            ++n2;
        }
    }

    public boolean isIndexSelected(int n) {
        return this.isSelected(n);
    }

    public boolean isSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isMultipleMode() {
        return this.allowsMultipleSelections();
    }

    public boolean allowsMultipleSelections() {
        return this.multipleMode;
    }

    public synchronized void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    public synchronized void setMultipleSelections(boolean bl) {
        if (bl != this.multipleMode) {
            this.multipleMode = bl;
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                listPeer.setMultipleSelections(bl);
            }
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void makeVisible(int n) {
        this.visibleIndex = n;
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.makeVisible(n);
        }
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public Dimension preferredSize(int n) {
        Object object = Component.LOCK;
        synchronized (object) {
            ListPeer listPeer = (ListPeer)this.peer;
            Dimension dimension = listPeer != null ? listPeer.preferredSize(n) : super.preferredSize();
            Object var4_5 = null;
            return dimension;
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        Object object = Component.LOCK;
        synchronized (object) {
            Dimension dimension = this.rows > 0 ? this.preferredSize(this.rows) : super.preferredSize();
            Object var3_3 = null;
            return dimension;
        }
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize(int n) {
        Object object = Component.LOCK;
        synchronized (object) {
            ListPeer listPeer = (ListPeer)this.peer;
            Dimension dimension = listPeer != null ? listPeer.minimumSize(n) : super.minimumSize();
            Object var4_5 = null;
            return dimension;
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        Object object = Component.LOCK;
        synchronized (object) {
            Dimension dimension = this.rows > 0 ? this.minimumSize(this.rows) : super.minimumSize();
            Object var3_3 = null;
            return dimension;
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        switch (aWTEvent.id) {
            case 1001: {
                return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
            }
            case 701: {
                return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
            }
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",selected=" + this.getSelectedItem();
    }

    public synchronized void delItems(int n, int n2) {
        int n3 = n2;
        while (n3 >= n) {
            this.items.removeElementAt(n3);
            --n3;
        }
        ListPeer listPeer = (ListPeer)this.peer;
        if (listPeer != null) {
            listPeer.delItems(n, n2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        List list = this;
        synchronized (list) {
            ListPeer listPeer = (ListPeer)this.peer;
            if (listPeer != null) {
                this.selected = listPeer.getSelectedIndexes();
            }
        }
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "itemL") {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            if (string == "actionL") {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }
}

