/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tables;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;
import sunw.hotjava.doc.DocConstants;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.FormatterOwner;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.Length;
import sunw.hotjava.tables.BGColorInfo;
import sunw.hotjava.tables.DeliberatelyPaintable;
import sunw.hotjava.tables.TableElementFormatter;
import sunw.hotjava.tables.TablePanel;
import sunw.hotjava.tags.TagAppletPanel;

public class TableElementPanel
extends Container
implements DocPanel,
DocConstants,
FormatterOwner,
DeliberatelyPaintable {
    TableElementFormatter current;
    private int padding;
    private boolean hasBorder;
    private boolean isCaption = false;
    TablePanel owner;

    public TableElementPanel(Document document, DocumentState documentState, DocItem docItem, TablePanel tablePanel, Length length, Length length2, int n, int n2, int n3, BGColorInfo bGColorInfo) {
        this.setLayout(null);
        this.owner = tablePanel;
        this.isCaption = this.isTag(document, docItem, "caption");
        this.hasBorder = this.owner.needsBorder() && !this.isCaption;
        this.padding = this.getCellPadding();
        if (docItem.getOffset() > 1 && this.hasBorder) {
            ++this.padding;
        }
        this.current = new TableElementFormatter(this, documentState, document, docItem, length, length2, n, n2, n3, bGColorInfo);
    }

    TableElementPanel(TableElementPanel tableElementPanel, TablePanel tablePanel, DocumentState documentState) {
        this.setLayout(null);
        this.owner = tablePanel;
        this.padding = tableElementPanel.padding;
        this.hasBorder = tableElementPanel.hasBorder;
        this.isCaption = tableElementPanel.isCaption;
        this.current = new TableElementFormatter(tableElementPanel.current, this, documentState);
    }

    public Formatter getFormatter() {
        return this.current;
    }

    private boolean isCaption() {
        return this.isCaption;
    }

    private boolean isTag(Document document, DocItem docItem, String string) {
        TagItem tagItem = docItem.getTag(document);
        if (tagItem == null) {
            return false;
        }
        return string.equals(tagItem.getName());
    }

    public void paint(Graphics graphics) {
        this.paintBackgroundAndWell(graphics);
        if (this.current != null) {
            this.current.paint(graphics);
        }
    }

    public void repaint() {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintDeliberately(Graphics graphics) {
        this.paint(graphics);
    }

    public void print(Graphics graphics) {
        if (this.hasBorder && !this.isEmpty()) {
            this.drawWell(graphics, Color.white);
        }
        if (this.current != null) {
            this.current.print(graphics);
        }
    }

    private void paintBackgroundAndWell(Graphics graphics) {
        this.paintBack(graphics);
        if (this.hasBorder && !this.isEmpty()) {
            this.drawWell(graphics, this.getBackground());
        }
    }

    private void drawWell(Graphics graphics, Color color) {
        Color color2 = graphics.getColor();
        if (color != null) {
            graphics.setColor(Globals.getVisible3DColor(color));
        }
        Dimension dimension = this.getSize();
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
        graphics.setColor(color2);
    }

    boolean isEmpty() {
        return this.current.getNumItems() == 0;
    }

    private void paintBack(Graphics graphics) {
        DocumentState documentState = this.current.getDocumentState();
        Dimension dimension = this.getSize();
        if (documentState.bg != null && !this.current.isFormatterBackgroundColorDeliberate()) {
            Point point = new Point(0, 0);
            this.getBackgroundDisplacement(point);
            documentState.bg.paint(graphics, point.x, point.y, 0, 0, dimension.width, dimension.height);
            return;
        }
        if (this.getBackground() != null) {
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(color);
        }
    }

    boolean paintRangeNoFloaters(Graphics graphics, int n, int n2, boolean bl) {
        return this.current.paintRangeNoFloaters(graphics, n, n2, bl);
    }

    boolean paintRange(Graphics graphics, int n, int n2, boolean bl) {
        return this.current.paintRange(graphics, n, n2, bl);
    }

    boolean intersectsRange(int n, int n2) {
        return n >> 16 < this.current.getMaxIndex() && this.current.getStartIndex() <= n2 >> 16;
    }

    void getFormPanel(Vector vector) {
        this.current.getFormPanel(vector);
    }

    public int getCellPadding() {
        return this.owner.getCellPadding();
    }

    public int getCellSpacing() {
        return this.owner.getCellSpacing();
    }

    public int getBorderThickness() {
        if (this.hasBorder && !this.isEmpty()) {
            return 1;
        }
        return 0;
    }

    int getColSpan() {
        return this.current.getColSpan();
    }

    int getRowSpan() {
        return this.current.getRowSpan();
    }

    void adjustSpanBy(int n, boolean bl) {
        this.current.adjustSpanBy(n, bl);
    }

    void doVerticalAlignment() {
        this.current.doVerticalAlignment();
    }

    public Document getDocument() {
        if (this.current != null) {
            return this.current.getDocument();
        }
        return null;
    }

    void getBackgroundDisplacement(Point point) {
        Point point2 = this.getLocation();
        point.translate(-point2.x, -point2.y);
        this.owner.getBackgroundDisplacement(point);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.current.setSize(n, n2);
    }

    public void activateSubItems() {
        this.current.activateSubItems();
    }

    public void start() {
        Color color = this.current.getFormatterBackgroundColor();
        if (color != null) {
            this.setBackground(color);
        }
        this.current.registerListeners();
        this.current.start();
    }

    public void stop() {
        this.current.stop();
        this.current.unregisterListeners();
    }

    public void unregisterListeners() {
        this.current.unregisterListeners();
    }

    public void destroy() {
        this.current.destroy();
    }

    public void interruptLoading() {
        this.current.interruptLoading();
    }

    public void notify(Document document, int n, int n2, int n3) {
        this.current.notify(document, n, n2, n3);
    }

    public void reformat() {
        this.current.reformat();
    }

    public int findYFor(int n) {
        return this.current.findYFor(n);
    }

    boolean containsPos(int n) {
        return this.current.containsPos(n);
    }

    TagAppletPanel getAppletPanel(String string) {
        return this.current.getAppletPanel(string);
    }

    void getAppletPanels(Vector vector) {
        this.current.getAppletPanels(vector);
    }

    void measure(Measurement measurement) {
        this.current.measure(measurement);
        measurement.adjustBy(2 * this.padding);
    }

    int getElementHeight() {
        return this.current.getElementHeight() + this.padding;
    }

    int getAdjustedElementHeight() {
        return this.current.getAdjustedElementHeight() + this.padding;
    }

    Length getCellWidth() {
        return this.current.getCellWidth();
    }

    Length getCellHeight() {
        return this.current.getCellHeight();
    }

    int getBaseline() {
        return this.current.getBaseline();
    }

    void setCommonBaseline(int n) {
        this.current.setCommonBaseline(n);
    }

    void setAssignedWidth(int n) {
        this.current.setAssignedWidth(n -= this.getCellSpacing());
    }

    public Formatter getParentFormatter() {
        return this.owner.getParentFormatter();
    }

    void touch(boolean bl, int n) {
        this.owner.touch(bl, n);
    }

    void touch(boolean bl, int n, DocItem docItem) {
        this.owner.touch(bl, n, docItem);
    }
}

