/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.URLSaver;
import sunw.hotjava.ui.BPSIndicator;
import sunw.hotjava.ui.BytesTransferredInd;

public class ProgressDialog
extends Dialog
implements Runnable {
    private static final long kSleepInterval = 100L;
    private static final int k1K = 1024;
    private static final int k1M = 0x100000;
    private URLSaver saver;
    private String bytesTransferredPrefix;
    private Label bytesTransferredLabel;
    private BytesTransferredInd bytesTransferredInd;
    private BPSIndicator bpsInd;
    private Button stopButton;
    private long totalBytes;
    private long bytesTransferred;
    private long transferStartTime;
    private Thread myThread;

    public ProgressDialog(Frame frame, String string, URLSaver uRLSaver) {
        super(frame, string, false);
        this.saver = uRLSaver;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        String string2 = Globals.localProps.handleGetString("progressDialog.url.label", "Source:");
        this.addComponent(gridBagLayout, gridBagConstraints, new Label(String.valueOf(string2) + " " + uRLSaver.getURL()));
        string2 = Globals.localProps.handleGetString("progressDialog.saveInto.label", "Destination:");
        this.addComponent(gridBagLayout, gridBagConstraints, new Label(String.valueOf(string2) + " " + uRLSaver.getFileName()));
        gridBagConstraints.ipady = 2;
        this.bytesTransferredPrefix = String.valueOf(Globals.localProps.handleGetString("progressDialog.transfer.label", "Bytes transferred:")) + " ";
        this.bytesTransferredInd = new BytesTransferredInd();
        this.addComponent(gridBagLayout, gridBagConstraints, this.bytesTransferredInd);
        this.bpsInd = new BPSIndicator();
        this.addComponent(gridBagLayout, gridBagConstraints, this.bpsInd);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.stopButton = new Button(Globals.localProps.handleGetString("progressDialog.stop.label", "Stop"));
        this.addComponent(gridBagLayout, gridBagConstraints, this.stopButton);
        this.pack();
        this.centerOnScreen(frame);
        this.show();
    }

    private void addComponent(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void centerOnScreen(Frame frame) {
        Point point = frame.getLocationOnScreen();
        Dimension dimension = frame.getSize();
        Dimension dimension2 = this.getSize();
        point.x += (dimension.width - dimension2.width) / 2;
        point.y += (dimension.height - dimension2.height) / 2;
        ((Component)this).setLocation(point.x, point.y);
    }

    public void start() {
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public void stop() {
        ((Component)this).hide();
        this.myThread.interrupt();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        this.transferStartTime = System.currentTimeMillis();
        while (true) {
            if (thread.isInterrupted()) {
                thread.interrupt();
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                break;
            }
            this.updateDisplay();
        }
        this.dispose();
    }

    private void updateDisplay() {
        long l = this.saver.getBytesTransferred();
        if (this.bytesTransferred != l) {
            this.bytesTransferred = l;
            this.bytesTransferredInd.updateBytesTransferred(l);
        }
        this.updateTransferSpeed(l);
    }

    private void updateTransferSpeed(long l) {
        long l2 = System.currentTimeMillis();
        double d = 0.0;
        if (l2 > this.transferStartTime) {
            d = (double)l * 1000.0 / (double)(l2 - this.transferStartTime);
        }
        this.bpsInd.updateBPS((long)(d + 0.5));
        this.validate();
    }

    static String convertToReadableValue(long l) {
        String string = "";
        if (l >= 0x100000L) {
            l = l * 10L / 0x100000L;
            return String.valueOf(ProgressDialog.format1decimalPlace(l)) + "M";
        }
        if (l >= 1024L) {
            l = l * 10L / 1024L;
            return String.valueOf(ProgressDialog.format1decimalPlace(l)) + "K";
        }
        return String.valueOf(l) + string;
    }

    private static String format1decimalPlace(long l) {
        long l2 = l % 10L;
        return String.valueOf(l /= 10L) + "." + l2;
    }

    public synchronized void setTotalBytes(long l) {
        this.bytesTransferredInd.setTotalBytes(l);
        this.validate();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.stopButton) {
            this.saver.stop();
            ((Component)this).hide();
            return true;
        }
        return super.action(event, object);
    }

    public void update(Graphics graphics) {
        ((Container)this).paint(graphics);
    }
}

