#!/usr/bin/gawk -f
function stripit ( pval ) {
  if( substr(pval,0,1) == "\"" ) {
    pval = substr(pval,2,length(pval)-1);
    if( match( pval , "\"" ) )
      pval = substr(pval,0,RSTART-1);
  }
  else if( match(pval," ") )
    pval = substr(pval,0,RSTART-1);
  gsub( "\>" , "", pval );
  return pval;
}

BEGIN { 
  RS = "\<" ; 
  FS = "\>" ; 
  underline = "________________________________________________________________________________"
  blanks = "                                                                                "
  tnst = 0;
}

{
  if( substr(toupper($1),0,4) == "FORM" ) {

    method="(none)";
    if( match(toupper($1), "METHOD=") ) {
      method = substr($1, RSTART+7 , 64 );
      if( match(method," ") )
	method = substr(method,0,RSTART-1);
      gsub( "\>" , "", method );
      gsub( "\"" , "" , method );
    }

    url="(unknown)";
    if( match(toupper($1), "ACTION=") ) {
      url = substr($1, RSTART+7 , 64 );
      if( match(url," ") )
	url = substr(url,0,RSTART-1);
      gsub( "\>" , "", url );
      gsub( "\"" , "" , url );
    }

#enctype

    print "#upget (...)" url " -r " method ; 
    print "#BEGIN----------------------------------------"
    tnst++;
  }
  
  if( tnst ) {	
    if( substr(toupper($1),0,8) == "TEXTAREA" ) {
      print "#" $1 $2;
    }

    if( substr(toupper($1),0,5) == "INPUT" ||
	substr(toupper($1),0,6) == "KEYGEN" ) {
#when blank...
      type = "TEXT";
      if( match(toupper($1), "TYPE=") ) {
	type = substr($1,RSTART+5,64);
	type = stripit( type );
      }

#image / src=url , name (ret name.x= name.y=).
#file

      name = "";
      value = "";
      checked = "echo -n \\&";
      size = 0;
      maxlength = 0;

      gsub("\n","",$1);
      gsub("\r","",$1);

      if( match(toupper($1), "NAME=") ) {
	name = substr($1,RSTART+5,64);
	name = stripit( name );
	gsub( " ", "+", name );
      }

      if( match(toupper($1), "VALUE=") ) {
	value = substr($1,RSTART+6,64);
	value = stripit( value );
	gsub( " ", "+", value );
	gsub( "&", "%26", value );
      }

      if( match(toupper(type),"RADIO") || match(toupper(type),"CHECKBOX") ) {
	checked = "#echo -n \\&";
	if( match(toupper($1), "CHECKED") )
	  checked = "echo -n \\&";
      }
      else if( match(toupper(type),"TEXT" ) || match(toupper(type),"PASSWORD") || match(toupper(type),"HIDDEN")  ) {

	if( match(toupper($1), "SIZE=") ) {
	  size = substr($1,RSTART+5,64);
	  size = stripit( size );
	}

	if( match(toupper($1), "MAXLENGTH=") ) {
	  maxlength = substr($1,RSTART+10,64);
	  maxlength = stripit( maxlength );
	}

      }
      else if( match(toupper(type),"SUBMIT" ) ) {
	checked = "#SUBMIT#echo -n \\&"
      }
      else if( match(toupper(type),"RESET" ) ) {
	checked = "#RESET#"
      }

      gsub("\n","",$2);
      gsub("\r","",$2);
      gsub("\t"," ",$2);

      print checked name "=" value \
	substr( blanks, 0, maxlength - length(value) ) \
	" #(" type ") " $2

#	substr( underline, 0, maxlength - size - length(value) ) \

    }
    
    if( substr(toupper($1),0,6) == "SELECT" ) {

      gsub("\n","",$1);
      gsub("\r","",$1);

      name = "\t";
      if( match(toupper($1), "NAME=") ) {
	name = substr($1,RSTART+5,64);
	if( match(name," ") )
	  name = substr(name,1,RSTART-1 );
	gsub( "\>" , "", name );
	gsub( "\"" , "" , name );
      }

      print "#"
      if( match(toupper($1), "MULTIPLE") )
	print "#SELECT MULTIPLE:" name;
      else
	print "#SELECT:" name;

      while ( 1 ) {
	getline;

	gsub("\n","",$1);
	gsub("\r","",$1);
	gsub("\n","",$2);
	gsub("\r","",$2);
	gsub("\t"," ",$2);

	if( substr(toupper($1),0,6) == "OPTION" ) {
	  value = "";
	  if( match(toupper($1), "VALUE=") )
	    value = substr($1,RSTART+6,64);
	  else
	    value = $2;
	  gsub( "^ ","", value );
	  if( match(value," ") )
	    value = substr(value,0,RSTART-1);
	  gsub( "\>" , "", value );
	  gsub( "\"" , "" , value );

	  if( match(toupper($1), "SELECTED") )
	    print "echo -n \\&" name "=" value " #" $2;
	  else
	    print "#echo -n \\&" name "=" value " #" $2;
	}

	if( substr(toupper($1),0,7) == "/SELECT" )
	  break;
      }
      print "#"

    }

    if( substr(toupper($1),0,5) == "/FORM" ) {
      print "echo"
	print "#END----------------------------------------"
      tnst--;
    }
  }

}

END { 
print ""; 
}

