-- ============================================================
--   Database name  :  LIVEPAYMENT                             
--   DBMS name      :  INFORMIX SQL 5.01                       
--   Created on     :  9/3/96  10:59 AM                       
--   Application    :  Starter Application Version 1.0.0
-- ============================================================

create database LIVEPAYMENT with log;

-- ============================================================
--   Table : LP_STATUSTYPE                                        
-- ============================================================
create table LP_STATUSTYPE
(
    STATUSTYPE          VARCHAR(20)           not null,
    primary key (STATUSTYPE) constraint pk_lp_statustype
);

-- ============================================================
--   Table : LP_CARDTYPE                                        
-- ============================================================
create table LP_CARDTYPE
(
    CARDTYPE          VARCHAR(20)           not null,
    CARDNAME          VARCHAR(30)                   ,
    primary key (CARDTYPE) constraint pk_lp_cardtype
);

-- ============================================================
--   Table : LP_MATCHQUERY                                        
-- ============================================================
create table LP_MATCHQUERY
(
    ID                INTEGER          not null,
    primary key (ID) constraint pk_lp_matchquery
);

-- ============================================================
--   Table : LP_BATCH                                           
-- ============================================================
create table LP_BATCH
(
    ID                  INTEGER               not null,
    BATCHNUMBER         VARCHAR(10)                   ,
    MERCHANTREFERENCE   VARCHAR(50)                   ,
    CURRENCY            VARCHAR(3)                    ,
    TOTALSALESAMOUNT    INTEGER                       ,
    TOTALCREDITAMOUNT   INTEGER                       ,
    SALESCOUNT          INTEGER                       ,
    CREDITCOUNT         INTEGER                       ,
    STATUS              VARCHAR(20)                   ,
    TIMESETTLED         DATETIME year to fraction(3)         ,
    primary key (ID) constraint pk_lp_batch
);

-- ============================================================
--   Table : LP_SLIP                                            
-- ============================================================
create table LP_SLIP
(
    ID                  INTEGER               not null,
    SLIPDER             TEXT                          ,
    primary key (ID) constraint pk_lp_slip
);

-- ============================================================
--   Table : LP_PURCHASE                                        
-- ============================================================
create table LP_PURCHASE
(
    ID                  INTEGER               not null,
    MERCHANTREFERENCE   VARCHAR(50)                   ,
    CARDHOLDERNAME      VARCHAR(60)                   ,
    CURRENCY            VARCHAR(3)                    ,
    AMOUNT              INTEGER                       ,
    AUTHCODE            VARCHAR(20)                   ,
    PAYSVCDATA          VARCHAR(50)                   ,
    AVSRESP             VARCHAR(20)                   ,
    EVENTID             VARCHAR(10)                   ,
    EVENTTIME           DATETIME year to fraction(3)         ,
    SLIPID              INTEGER                       ,
    BATCHID             INTEGER                       ,
    STATUS              VARCHAR(20)                   ,
    primary key (ID) constraint pk_lp_purchase
);

alter table LP_PURCHASE
    add constraint foreign key (SLIPID)
       references LP_SLIP (ID) constraint fk1_lp_purchase;

alter table LP_PURCHASE
    add constraint foreign key (BATCHID)
       references LP_BATCH (ID) constraint fk2_lp_purchase;

load from "status.unl" insert into LP_STATUSTYPE;
load from "cardtype.unl" insert into LP_CARDTYPE;
