// === Starter Application 1.0.0 === //

// **************************************************
// GENERIC FUNCTIONS
// **************************************************

/* ======================================================

FUNCTION:  CentsToDollarStr()

INPUT:     cents - a string representing a value in cents

RETURNS:   a string representing the input value in dollars

====================================================== */

function CentsToDollarStr(cents)
{
  cents = cents + "";  	// Convert to string in case a numeric value was passed in

  if (cents.length == 1)
    return("0.0"+cents);
  if (cents.length == 2)
    return("0."+cents);
 
  return(cents.substring(0, cents.length - 2) + "." +
         cents.substring(cents.length - 2, cents.length));
} // END CentsToDollarStr()



/* ===================================================
 FUNCTION:  RemoveAlpha(cardNumber)
 
 INPUT:  cardNumber - a credit card number

 RETURN: newCard - the credit card number with all dashes, spaces,
		and other non-numeric characters removed.

 =================================================== */
function RemoveAlpha(cardNumber)
{

var	newCard = "";
var	i = 0;

	// Loop through entire string, checking each character to ensure it's a valid string.
	
	while (i < cardNumber.length)
	{
	if ( (cardNumber.charAt(i) >= "0") && (cardNumber.charAt(i) <= "9") )
		newCard = newCard + cardNumber.charAt(i);
	i++;  
	} // END while loop		
	return newCard;

}  // END FUNCTION RemoveAlpha()



/* ===================================================
 FUNCTION:  IsBlank()
 
 INPUT:   teststr - the string to be tested to ensure that

 RETURN:  true, if the string is null or is an empty string, ""
 	  false, otherwise.

 NOTE:    This function is used to test strings only.  Inputting
	a numeric or boolean variable will give unpredictable results.

 =================================================== */

function IsBlank( teststring )
{
   var result = false;

   if ( (teststring == null) || (teststring == "") )
	result = true;

   return result;


}  // END FUNCTION IsBlank()




/* ===================================================
 FUNCTION:  IsNum()
 
 INPUT:  numstr - a string that will be tested to ensure that
		each character is a digit

 RETURN:  true, if all characters in the string are a character from 0-9
	  false, otherwise.

 NOTE:    This function is used to test strings only.  Inputting
	a numeric or boolean variable will give unpredictable results.

 =================================================== */

function IsNum( numstr )
{
var i = 0;
var IsValid = true;

	for (i = 0; i < numstr.length; i++)
	{
		if ((numstr.charAt(i) < "0") || (numstr.charAt(i) > "9"))
			IsValid = false;
	} // END for	
	
	return IsValid;

}  // END FUNCTION IsNum()


/* ===================================================
 FUNCTION:  DollarStrToCents()

 INPUT:  dollarstr - a string representing a dollar amount

 RETURN:  a numeric value representing the input string converted
	from dollars to cents

 =================================================== */


function DollarStrToCents( dollarstr )
{
   	var cents = 0;

   	cents = parseFloat(dollarstr) * 100;

	return cents;

} //END FUNCTION DollarStrToCents()




/* ===================================================
 FUNCTION:  IsValidPrice()
 
 INPUT:  pricestr - a string representing a price

 RETURN:  true, if the value is a valid price, where validity
		relies upon the string containing only:
			* characters from 0-9
			* at most one '.' character for an optional 
			  decimal place

	  false, if the value does not conform to the above rules

 =================================================== */

function IsValidPrice( pricestr )
{

var	decimalcount = 0;   // keeps track of the number of '.' chars
var	IsValid = true;
var	i = 0;

	// Loop through entire string, checking each character to
	// ensure it's a valid string.  Allow only one decimal point in
	// the string by counting them using "decimalcount".

	while ( (i < pricestr.length) && (IsValid) )
	{
	   if ( (pricestr.charAt(i) < "0") || (pricestr.charAt(i) > "9") )
		if (pricestr.charAt(i) != ".") 
		   	// If not character '0'-'9' or '.', its not valid
			IsValid = false; 		

		else	// otherwise it's a '.'
		{
			decimalcount++;
			if (decimalcount > 1) {
				// if more than one '.', its not valid
				IsValid = false;  }
		} // END else
			   
	   i++;  
	} // END while loop				

	return IsValid;

}  // END FUNCTION IsValidPrice()




/* ===================================================
 FUNCTION:  IsValidDay()

 INPUT:  daystr - a string representing a day of the month

 RETURN:  true, if the string represents a number from 1 to 31
	  false, if the string does not conform to the above rules

 NOTE:  This function does not attempt to associate the number of days
	with any particular month.  E.G.  it does not attempte to judge
	whether February 30th is valid. It only ensures that months 
	can only have valid values in a range from 1 to 31.

 =================================================== */

function IsValidDay( daystr )
{

var	day = 0;
var	IsValid = false;

  if (IsNum(daystr))
  {
	day = parseInt(daystr);

	if ( (day >= 1) && (day <= 31) )
		IsValid = true;

	return IsValid;

  }  // END if

}  // END FUNCTION IsValidDay()



/* ===================================================
 FUNCTION:  IsValidYear()

 INPUT:  yearstr - a string representing a 4-digit year

 RETURN:  true, if the string represents a 4-digit number
	  false, otherwise.

 =================================================== */

function IsValidYear( yearstr )
{
var	year = 0;
var	IsValid = false;

   if ( !IsBlank(yearstr) && IsNum(yearstr) )
   {
	year = parseInt(yearstr);

	if (yearstr.length == 4)
		IsValid = true;
		
	return IsValid;

   } // END if

} // END FUNCTION IsValidYear()


// **************************************************
// INFORMATION RETRIEVAL FUNCTIONS
// **************************************************


/* ======================================================

FUNCTION:  GetCardType()

INPUT:     slipid - id of the slip associated with the transaction
	in question.

RETURN:   Given a particular slip id, this function returns the cardType
	indicated by that slip.  If no slip matches the slipID, this
	function returns an empty string (e.g.  "").

====================================================== */

function GetCardType(slipid)
{

	var	cardType = "";

	if ( (slipid + "") != "null" )
	{	
	   scursor = database.cursor("select slipDER from LP_SLIP where id = '" + slipid + "'");

	   if (scursor.next()) 
	   {
		slip = new Slip(scursor.slipDER);
		cardType = slip.cardType;
	   }

	   scursor.close();

	} else {
	    cardType = "n/a";
	}

	return cardType;

} // END GetCardType()



/* ======================================================

FUNCTION:  IsExistingPurchaseID()

INPUT:     id - id of the transaction in question

RETURN:   true, if the id is valid and exists in the LP_PURCHASE
		table.
	  false, otherwise.

====================================================== */

function IsExistingPurchaseID( id )
{
   var result = false;

   if ( !IsBlank(id) && IsNum(id) )
   {
	cursor = database.cursor("select ID from LP_PURCHASE where ID = " + id);
	if (cursor.next())
	{
		result = true;
		cursor.close();
	}
   }
   return result;

} // END FUNCTION IsExistingPurchaseID



