/*
 # $Id: index.c,v 1.8 1997/11/25 11:20:43 fbm Exp fbm $
 # Copyright (C) 1997,1998 Farrell McKay
 # All rights reserved.
 #
 # This file is part of the Fortify distribution, a toolkit for
 # upgrading the cryptographic strength of the Netscape Navigator
 # web browser, authored by Farrell McKay.
 #
 # This toolkit is provided to the recipient under the
 # following terms and conditions:-
 #   1.  This copyright notice must not be removed or modified.
 #   2.  This toolkit may not be reproduced or included in any commercial
 #       media distribution, or commercial publication (for example CD-ROM,
 #       disk, book, magazine, journal) without first obtaining the author's
 #       express permission.
 #   3.  This toolkit, or any component of this toolkit, may not be
 #       commercially resold, redeveloped, rewritten, enhanced or otherwise
 #       used as the basis for commercial venture, without first obtaining
 #       the author's express permission.
 #   4.  Subject to the above conditions being observed (1-3), this toolkit
 #       may be freely reproduced or redistributed.
 #   5.  This software is provided "as-is", without express or implied
 #       warranty.  In no event shall the author be liable for any direct,
 #       indirect or consequential damages however caused.
 #   6.  Subject to the above conditions being observed (1-5),
 #       this toolkit may be used at no cost to the recipient.
 #
 # Farrell McKay			contact@fortify.net
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "misc.h"
#include "index.h"
#include "morpher.h"
#include "md5_calc.h"

#define VERN_STR	"version"

static int		idx_sz;
static index_entry_t	**idx_ents;

int
have_morphs(index_entry_t *ent)
{
	return (ent->flds[IDX_MORPHS] && ent->flds[IDX_MORPHS][0] != '\0');
}

int
build_index(char *indexfile, char **vern)
{
	char		buf[1024];
	FILE		*ifp;
	int		i, len, nflds;
	int		vern_seen	= 0;
	char		*p;
	index_entry_t	*ent;

	idx_sz = 0;

	ifp = fopen(indexfile, "r");
	if (ifp == NULL) {
		fprintf(stderr, "Cannot open \"%s\": ", indexfile);
		perror("");
		return -1;
	}

	while (fgets(buf, sizeof(buf), ifp)) {
		if (*buf == '#' || *buf == '\n')
			continue;
		len = strlen(buf);
		if (len <= 1)
			continue;
		
		if (!vern_seen && strncmp(buf, VERN_STR, strlen(VERN_STR)) == 0) {
			p = buf + strlen(VERN_STR);
			while (isspace(*p))
				p++;
			*vern = _strndup(p, strlen(p)-1);
			vern_seen++;
			continue;
		}

		ent = (index_entry_t *) _calloc(1, sizeof(index_entry_t));

		ent->raw = p = _strndup(buf, len);

		for (i = nflds = 0; i < IDX_NFLDS; i++) {
			while (isspace(*p))
				p++;
			ent->flds[i] = p;
			while (*p && !isspace(*p))
				p++;
			*p = '\0';
			if (strlen(ent->flds[i]) > 0)
				nflds++;
			if (strcmp(ent->flds[i], "-") == 0)
				ent->flds[i] = p;
			if (i == IDX_GRADE) {
				if (strcmp(ent->flds[i], "exp") == 0)
					ent->flds[i] = "Export";
				else if (strcmp(ent->flds[i], "ffy") == 0)
					ent->flds[i] = "Fortify";
				else if (strcmp(ent->flds[i], "dom") == 0)
					ent->flds[i] = "U.S. Domestic";
			}
			if (p < ent->raw + len)
				p++;
		}

		if (nflds != IDX_NFLDS) {
			free(ent->raw);
			free(ent);
			continue;
		}

		ent->size = atoi(ent->flds[IDX_SZ]);
		ent->ismorphed = (strcmp(ent->flds[IDX_GRADE], "Fortify") == 0);

		idx_sz++;
		idx_ents = (index_entry_t **) _realloc((void *) idx_ents,
				idx_sz * sizeof(index_entry_t *));
		idx_ents[idx_sz - 1] = ent;
	}

	fclose(ifp);
	return idx_sz;
}

index_entry_t *
index_lookup(char *tgt)
{
	int		i, ifd;
	struct stat	st;
	index_entry_t	*ip;
	char		*md5 = NULL;
	char		*md5span = NULL;

	if ((ifd = open(tgt, OPENFL(O_RDONLY), 0666)) == -1
		|| fstat(ifd, (struct stat *) &st) == -1) {
		fprintf(stderr, "Cannot open \"%s\": ", tgt);
		perror("");
		return NULL;
	}

	for (i = 0; i < idx_sz; i++) {
		ip = idx_ents[i];
		if (ip->size == st.st_size) {
			if (md5 == NULL || strcmp(ip->flds[IDX_MD5SPAN], md5span) != 0) {
				md5 = md5_calc(ifd, ip->flds[IDX_MD5SPAN]);
				md5span = ip->flds[IDX_MD5SPAN];
			}
			if (strcmp(ip->flds[IDX_MD5], md5) == 0)
				return ip;
		}
	}
	return NULL;
}
