/*
This program is distributed in the hope that it will be useful,
but without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose. You use
this program at your own risk. The author disclaims responsibility for
any damages that might result from the use of this program, even
if they result from negligence on the part of the author.

Also, please don't use this program to steal software. The intended
use is for emergency situations where an application has to be moved from
one computer to another (e.g. in the event of a hardware malfunction)
and licence keys cannot be obtained quickly from the vendor. Many
vendors will not supply licence keys outside of business hours.
*/

#include <sys/user.h>
#define NHOSTID 10

static unsigned hostid[NHOSTID]={0};

Gethostid()
{
    unsigned machineid;
    u_short gid;
    int i;

    gethostid();
    machineid = u.u_r.r_val1;

    gid = u.u_gid;
    if (gid >= 900 && gid < 900+NHOSTID) {
        u.u_r.r_val1 = hostid[gid-900] ? hostid[gid-900] : machineid;
        return;
    }

    i = 0;
    while (gid=u.u_groups[i++]) {
        if (gid >= 900 && gid < 900+NHOSTID) {
            u.u_r.r_val1 = hostid[gid-900] ? hostid[gid-900] : machineid;
            return;
        }
    }
    u.u_r.r_val1 = machineid;
    return;
}

sethostid(uap)
    register struct a {
        int n;
        unsigned hostid;
    } *uap;
{
    if (!suser()) {
        u.u_error = EACCES;
        return;
    }

    if ((uap->n >= NHOSTID )||(uap->n < 0)) {  /* small change - markh */
        u.u_error = EINVAL;
        return;
    }

    u.u_r.r_val1 = hostid[uap->n] = uap->hostid;
    u.u_error = 0;
    return;
}
