/* pkcrack - s2main.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: s2main.c,v 1.1 1996/06/10 17:56:53 conrad Exp $
 *
 * $Log: s2main.c,v $
 * Revision 1.1  1996/06/10 17:56:53  conrad
 * Initial revision
 *
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "crc.h"
#include "mktemptbl.h"
#include "pkcrack.h"
#include "stage2.h"

#ifndef O_BINARY
#define	O_BINARY	0
#endif

byte	plaintext[MAXFILELEN], ciphertext[MAXFILELEN];
int	numKey2s=0;

void main( int argc, char **argv )
{
int		crypt, plain, cryptlength, plainlength;
struct stat	filestat;

int		i;

    if( argc != 3 )
    {
	fprintf( stderr, "Usage: %s <crypted_file> <plaintext_file>\n", argv[0] );
	return;
    }

    crypt = open( argv[1], O_RDONLY | O_BINARY );
    if( crypt == -1 )
    {
	fprintf( stderr, "Cryptfile %s not found!\n", argv[1] );
	return;
    }
    plain = open( argv[2], O_RDONLY | O_BINARY );
    if( plain == -1 )
    {
	fprintf( stderr, "Plaintextfile %s not found!\n", argv[2] );
	return;
    }

    fstat( plain, &filestat );
    plainlength = filestat.st_size;
    fstat( crypt, &filestat );
    cryptlength = filestat.st_size;
    if( plainlength > cryptlength-12 )
    {
	fprintf( stderr, "Warning! Plaintext is longer than Ciphertext!\n" );
    }
    if( plainlength < 13 )
    {
	fprintf( stderr, "Plaintext must be at least 13 bytes! Aborting.\n" );
	return;
    }
    plainlength = 13;

    cryptlength = plainlength + 12;

    if( read( crypt, ciphertext, cryptlength ) !=  cryptlength )
    {
	fprintf( stderr, "Couldn't read ciphertext!\n" );
	return;
    }
    if( read( plain, &plaintext[12], plainlength ) != plainlength )
    {
	fprintf( stderr, "Couldn't read plaintext!\n" );
	return;
    }
    close( plain );
    close( crypt );

    preCompTemp();
    mkCrcTab();

    initMulTab();
    buildKey2Lists( 0xf5a9c1ab );
}

