/* ecb_encrypt.c v 1.0 eay 17/7/90
 */

#include "des_local.h"
#include "bits.h"
#include "sp.h"

#ifdef MSDOS
#define T	t.l
#define EB0(r) (((r.c[0]<<1)|((r.c[3]>>7)&0x01))&0x3f)
#define EB1(r) ((r.s[0]>>3)&0x3f)
#define EB2(r) ((r.s[0]>>7)&0x3f)
#define EB3(r) ((((r.c[1]>>3)&0x1f)|(r.c[2]<<5))&0x3f)
#define EB4(r) ((((r.c[1]>>7)&0x01)|(r.c[2]<<1))&0x3f)
#define EB5(r) ((r.s[1]>>3)&0x3f)
#define EB6(r) ((r.s[1]>>7)&0x3f)
#define EB7(r) ((((r.c[3]>>3)&0x1f)|(r.c[0]<<5))&0x3f)
#else
#define T	t
#define EB0(r)	((((r)<<1)|(((r)>>31)&0x01))&0x3f)
#define EB1(r)	(((r)>> 3)&0x3f)
#define EB2(r)	(((r)>> 7)&0x3f)
#define EB3(r)	(((r)>>11)&0x3f)
#define EB4(r)	(((r)>>15)&0x3f)
#define EB5(r)	(((r)>>19)&0x3f)
#define EB6(r)	(((r)>>23)&0x3f)
#define EB7(r)	(((((r)>>27)&0x1f)|((r)<<5))&0x3f)
#endif

#define S0	s[0]
#define S1	s[1]
#define S2	s[2]
#define S3	s[3]
#define S4	s[4]
#define S5	s[5]
#define S6	s[6]
#define S7	s[7]

static void do_IP();
static void do_FP();
static void des_encrypt_body();
static void des_decrypt_body();

static ulong ll[2];

/* I assume word alignment for input and output. */
int des_ecb_encrypt(input,output,ks,encrypt)
des_cblock *input;
des_cblock *output;
des_key_schedule ks;
int encrypt;
	{
	register uchar *in,*out;

	in=(uchar *)input;
	out=(uchar *)output;
	c2l(in,ll[0]);
	c2l(in,ll[1]);
	des_encrypt(ll,ll,(uchar *)ks,encrypt);
	l2c(ll[0],out);
	l2c(ll[1],out);
	return(0);
	}

int des_encrypt(input,output,ks,encrypt)
ulong *input;
ulong *output;
des_key_schedule ks;
int encrypt;
	{
	do_IP(input[0],input[1]);
	if (encrypt)
		des_encrypt_body(ll[0],ll[1],(uchar *)ks);
	else
		des_decrypt_body(ll[0],ll[1],(uchar *)&(ks[ITERATIONS-1]));
	do_FP();
	output[0]=ll[0];
	output[1]=ll[1];
	return(0);
	}

static void des_encrypt_body(l,r,s)
register ulong l,r;
register uchar *s;
	{
	register ulong t;
	register int i;

	for (i=ITERATIONS; i>0; i--)
		{
		t=r;
		r=l^(	SPtrans[0][EB0(t)^S0]|
			SPtrans[1][EB1(t)^S1]|
			SPtrans[2][EB2(t)^S2]|
			SPtrans[3][EB3(t)^S3]|
			SPtrans[4][EB4(t)^S4]|
			SPtrans[5][EB5(t)^S5]|
			SPtrans[6][EB6(t)^S6]|
			SPtrans[7][EB7(t)^S7]);
		l=t;
		s+=8;
		}
	ll[0]=r;
	ll[1]=l;
	}

static void des_decrypt_body(l,r,s)
register ulong l,r;
register uchar *s;
	{
	register int t;
	register int i;

	for (i=ITERATIONS; i>0; i--)
		{
		t=r;
		r=l^(	SPtrans[0][EB0(t)^S0]|
			SPtrans[1][EB1(t)^S1]|
			SPtrans[2][EB2(t)^S2]|
			SPtrans[3][EB3(t)^S3]|
			SPtrans[4][EB4(t)^S4]|
			SPtrans[5][EB5(t)^S5]|
			SPtrans[6][EB6(t)^S6]|
			SPtrans[7][EB7(t)^S7]);
		l=t;
		s-=8;
		}
	ll[0]=r;
	ll[1]=l;
	}

static void do_IP(l,r)
register unsigned long l,r;
	{
	register unsigned long retl=0,retr=0;

	if (l & B25) retl|=(ulong)(1L<< 4);
	if (l & B17) retl|=(ulong)(1L<< 5);
	if (l & B9 ) retl|=(ulong)(1L<< 6);
	if (l & B1 ) retl|=(ulong)(1L<< 7);
	if (l & B27) retl|=(ulong)(1L<<12);
	if (l & B19) retl|=(ulong)(1L<<13);
	if (l & B11) retl|=(ulong)(1L<<14);
	if (l & B3 ) retl|=(ulong)(1L<<15);
	if (l & B29) retl|=(ulong)(1L<<20);
	if (l & B21) retl|=(ulong)(1L<<21);
	if (l & B13) retl|=(ulong)(1L<<22);
	if (l & B5 ) retl|=(ulong)(1L<<23);
	if (l & B31) retl|=(ulong)(1L<<28);
	if (l & B23) retl|=(ulong)(1L<<29);
	if (l & B15) retl|=(ulong)(1L<<30);
	if (l & B7 ) retl|=(ulong)(1L<<31);

	if (r & B25) retl|=(ulong)(1L<< 0);
	if (r & B17) retl|=(ulong)(1L<< 1);
	if (r & B9 ) retl|=(ulong)(1L<< 2);
	if (r & B1 ) retl|=(ulong)(1L<< 3);
	if (r & B27) retl|=(ulong)(1L<< 8);
	if (r & B19) retl|=(ulong)(1L<< 9);
	if (r & B11) retl|=(ulong)(1L<<10);
	if (r & B3 ) retl|=(ulong)(1L<<11);
	if (r & B29) retl|=(ulong)(1L<<16);
	if (r & B21) retl|=(ulong)(1L<<17);
	if (r & B13) retl|=(ulong)(1L<<18);
	if (r & B5 ) retl|=(ulong)(1L<<19);
	if (r & B31) retl|=(ulong)(1L<<24);
	if (r & B23) retl|=(ulong)(1L<<25);
	if (r & B15) retl|=(ulong)(1L<<26);
	if (r & B7 ) retl|=(ulong)(1L<<27);

	if (l & B24) retr|=(ulong)(1L<< 4);
	if (l & B16) retr|=(ulong)(1L<< 5);
	if (l & B8 ) retr|=(ulong)(1L<< 6);
	if (l & B0 ) retr|=(ulong)(1L<< 7);
	if (l & B26) retr|=(ulong)(1L<<12);
	if (l & B18) retr|=(ulong)(1L<<13);
	if (l & B10) retr|=(ulong)(1L<<14);
	if (l & B2 ) retr|=(ulong)(1L<<15);
	if (l & B28) retr|=(ulong)(1L<<20);
	if (l & B20) retr|=(ulong)(1L<<21);
	if (l & B12) retr|=(ulong)(1L<<22);
	if (l & B4 ) retr|=(ulong)(1L<<23);
	if (l & B30) retr|=(ulong)(1L<<28);
	if (l & B22) retr|=(ulong)(1L<<29);
	if (l & B14) retr|=(ulong)(1L<<30);
	if (l & B6 ) retr|=(ulong)(1L<<31);

	if (r & B24) retr|=(ulong)(1L<< 0);
	if (r & B16) retr|=(ulong)(1L<< 1);
	if (r & B8 ) retr|=(ulong)(1L<< 2);
	if (r & B0 ) retr|=(ulong)(1L<< 3);
	if (r & B26) retr|=(ulong)(1L<< 8);
	if (r & B18) retr|=(ulong)(1L<< 9);
	if (r & B10) retr|=(ulong)(1L<<10);
	if (r & B2 ) retr|=(ulong)(1L<<11);
	if (r & B28) retr|=(ulong)(1L<<16);
	if (r & B20) retr|=(ulong)(1L<<17);
	if (r & B12) retr|=(ulong)(1L<<18);
	if (r & B4 ) retr|=(ulong)(1L<<19);
	if (r & B30) retr|=(ulong)(1L<<24);
	if (r & B22) retr|=(ulong)(1L<<25);
	if (r & B14) retr|=(ulong)(1L<<26);
	if (r & B6 ) retr|=(ulong)(1L<<27);

	ll[0]=retl;
	ll[1]=retr;
	}

static void do_FP()
	{
	register unsigned long r=ll[1],l=ll[0],retl=0,retr=0;

	if (l & (ulong)(1L<< 7)) retl|=B1 ;
	if (l & (ulong)(1L<<15)) retl|=B3 ;
	if (l & (ulong)(1L<<23)) retl|=B5 ;
	if (l & (ulong)(1L<<31)) retl|=B7 ;
	if (l & (ulong)(1L<< 6)) retl|=B9 ;
	if (l & (ulong)(1L<<14)) retl|=B11;
	if (l & (ulong)(1L<<22)) retl|=B13;
	if (l & (ulong)(1L<<30)) retl|=B15;
	if (l & (ulong)(1L<< 5)) retl|=B17;
	if (l & (ulong)(1L<<13)) retl|=B19;
	if (l & (ulong)(1L<<21)) retl|=B21;
	if (l & (ulong)(1L<<29)) retl|=B23;
	if (l & (ulong)(1L<< 4)) retl|=B25;
	if (l & (ulong)(1L<<12)) retl|=B27;
	if (l & (ulong)(1L<<20)) retl|=B29;
	if (l & (ulong)(1L<<28)) retl|=B31;

	if (r & (ulong)(1L<< 7)) retl|=B0 ;
	if (r & (ulong)(1L<<15)) retl|=B2 ;
	if (r & (ulong)(1L<<23)) retl|=B4 ;
	if (r & (ulong)(1L<<31)) retl|=B6 ;
	if (r & (ulong)(1L<< 6)) retl|=B8 ;
	if (r & (ulong)(1L<<14)) retl|=B10;
	if (r & (ulong)(1L<<22)) retl|=B12;
	if (r & (ulong)(1L<<30)) retl|=B14;
	if (r & (ulong)(1L<< 5)) retl|=B16;
	if (r & (ulong)(1L<<13)) retl|=B18;
	if (r & (ulong)(1L<<21)) retl|=B20;
	if (r & (ulong)(1L<<29)) retl|=B22;
	if (r & (ulong)(1L<< 4)) retl|=B24;
	if (r & (ulong)(1L<<12)) retl|=B26;
	if (r & (ulong)(1L<<20)) retl|=B28;
	if (r & (ulong)(1L<<28)) retl|=B30;

	if (l & (ulong)(1L<< 3)) retr|=B1 ;
	if (l & (ulong)(1L<<11)) retr|=B3 ;
	if (l & (ulong)(1L<<19)) retr|=B5 ;
	if (l & (ulong)(1L<<27)) retr|=B7 ;
	if (l & (ulong)(1L<< 2)) retr|=B9 ;
	if (l & (ulong)(1L<<10)) retr|=B11;
	if (l & (ulong)(1L<<18)) retr|=B13;
	if (l & (ulong)(1L<<26)) retr|=B15;
	if (l & (ulong)(1L<< 1)) retr|=B17;
	if (l & (ulong)(1L<< 9)) retr|=B19;
	if (l & (ulong)(1L<<17)) retr|=B21;
	if (l & (ulong)(1L<<25)) retr|=B23;
	if (l & (ulong)(1L<< 0)) retr|=B25;
	if (l & (ulong)(1L<< 8)) retr|=B27;
	if (l & (ulong)(1L<<16)) retr|=B29;
	if (l & (ulong)(1L<<24)) retr|=B31;

	if (r & (ulong)(1L<< 3)) retr|=B0 ;
	if (r & (ulong)(1L<<11)) retr|=B2 ;
	if (r & (ulong)(1L<<19)) retr|=B4 ;
	if (r & (ulong)(1L<<27)) retr|=B6 ;
	if (r & (ulong)(1L<< 2)) retr|=B8 ;
	if (r & (ulong)(1L<<10)) retr|=B10;
	if (r & (ulong)(1L<<18)) retr|=B12;
	if (r & (ulong)(1L<<26)) retr|=B14;
	if (r & (ulong)(1L<< 1)) retr|=B16;
	if (r & (ulong)(1L<< 9)) retr|=B18;
	if (r & (ulong)(1L<<17)) retr|=B20;
	if (r & (ulong)(1L<<25)) retr|=B22;
	if (r & (ulong)(1L<< 0)) retr|=B24;
	if (r & (ulong)(1L<< 8)) retr|=B26;
	if (r & (ulong)(1L<<16)) retr|=B28;
	if (r & (ulong)(1L<<24)) retr|=B30;

	ll[0]=retl;
	ll[1]=retr;
	}

#ifdef MSDOS
static void des_encrypt_body(l,r,s)
register ulong l,r;
register uchar *s;
	{
	LB t;
	uchar e[8];
	register int i;

	for (i=ITERATIONS; i>0; i--)
		{
		t.l=r;
		e[0]=EB0(t);
		e[1]=EB1(t);
		e[2]=EB2(t);
		e[3]=EB3(t);
		e[4]=EB4(t);
		e[5]=EB5(t);
		e[6]=EB6(t);
		e[7]=EB7(t);
		r=l^(	SPtrans[0][e[0]^S0]|
			SPtrans[1][e[1]^S1]|
			SPtrans[2][e[2]^S2]|
			SPtrans[3][e[3]^S3]|
			SPtrans[4][e[4]^S4]|
			SPtrans[5][e[5]^S5]|
			SPtrans[6][e[6]^S6]|
			SPtrans[7][e[7]^S7]);
		l=t.l;
		s+=8;
		}
	ll[0]=r;
	ll[1]=l;
	}

static void des_decrypt_body(l,r,s)
register ulong l,r;
register uchar *s;
	{
	LB t;
	uchar e[8];
	register int i;

	for (i=ITERATIONS; i>0; i--)
		{
		t.l=r;
		e[0]=EB0(t);
		e[1]=EB1(t);
		e[2]=EB2(t);
		e[3]=EB3(t);
		e[4]=EB4(t);
		e[5]=EB5(t);
		e[6]=EB6(t);
		e[7]=EB7(t);
		r=l^(	SPtrans[0][e[0]^S0]|
			SPtrans[1][e[1]^S1]|
			SPtrans[2][e[2]^S2]|
			SPtrans[3][e[3]^S3]|
			SPtrans[4][e[4]^S4]|
			SPtrans[5][e[5]^S5]|
			SPtrans[6][e[6]^S6]|
			SPtrans[7][e[7]^S7]);
		l=t.l;
		s-=8;
		}
	ll[0]=r;
	ll[1]=l;
	}
#endif
