/*
 * Copyright (c) 1997 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden). 
 * All rights reserved. 
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 *
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 *
 * 3. All advertising materials mentioning features or use of this software 
 *    must display the following acknowledgement: 
 *      This product includes software developed by Kungliga Tekniska 
 *      Hgskolan and its contributors. 
 *
 * 4. Neither the name of the Institute nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software 
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE. 
 */

#include "krb5_locl.h"

RCSID("$Id: sock_principal.c,v 1.3 1997/09/12 23:06:36 assar Exp $");
			
krb5_error_code
krb5_sock_to_principal (krb5_context context,
			int sock,
			const char *sname,
			int32_t type,
			krb5_principal *ret_princ)
{
    krb5_error_code ret;
#if defined(AF_INET6) && defined(HAVE_SOCKADDR_IN6)
    struct sockaddr_in6 addr;
#else
    struct sockaddr_in addr;
#endif
    int len = sizeof(addr);
    struct hostent *hostent;

    if (getsockname (sock, (struct sockaddr *)&addr, &len) < 0)
	return errno;
    
#if defined(AF_INET6) && defined(HAVE_SOCKADDR_IN6)
    if(len == sizeof(struct sockaddr_in6))
	hostent = gethostbyaddr ((const char *)&addr.sin6_addr,
				 sizeof(addr.sin6_addr),
				 addr.sin6_family);
    else {
	struct sockaddr_in *foo = (struct sockaddr_in *)&addr;
	
	hostent = gethostbyaddr ((const char *)&foo->sin_addr,
				 sizeof(foo->sin_addr),
				 foo->sin_family);
    }
#else
    hostent = gethostbyaddr ((const char *)&addr.sin_addr,
			     sizeof(addr.sin_addr),
			     addr.sin_family);
#endif

    if (hostent == NULL)
	return h_errno;
    return krb5_sname_to_principal (context,
				    hostent->h_name,
				    sname,
				    type,
				    ret_princ);
}
