/*
 * Copyright (c) 1997-1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden). 
 * All rights reserved. 
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 *
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 *
 * 3. All advertising materials mentioning features or use of this software 
 *    must display the following acknowledgement: 
 *      This product includes software developed by Kungliga Tekniska 
 *      Hgskolan and its contributors. 
 *
 * 4. Neither the name of the Institute nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software 
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE. 
 */

#include "kadm5_locl.h"

RCSID("$Id: randkey_s.c,v 1.6 1999/05/03 17:09:49 joda Exp $");

kadm5_ret_t
kadm5_s_randkey_principal(void *server_handle, 
			  krb5_principal princ,
			  krb5_keyblock **new_keys, 
			  int *n_keys)
{
    kadm5_server_context *context = server_handle;
    hdb_entry ent;
    kadm5_ret_t ret;

    ent.principal = princ;
    ret = context->db->open(context->context, context->db, O_RDWR, 0);
    if(ret)
	return ret;
    ret = context->db->fetch(context->context, context->db, 0, &ent);
    if(ret == HDB_ERR_NOENTRY)
	goto out;
    {
	/* XXX this should be merged with set_keys */
	int i;
	Key *key;
	*new_keys = malloc(ent.keys.len * sizeof(**new_keys));
	for(i = 0; i < ent.keys.len; i++){
	    key = &ent.keys.val[i];
	    if(key->salt){
		/* zap any salt */
		free_Salt(key->salt);
		key->salt = NULL;
	    }
	    krb5_free_keyblock_contents(context->context, &key->key);
	    ret = krb5_generate_random_keyblock(context->context,
						key->key.keytype,
						&key->key);

	    if(ret)
		break;
	    ret = krb5_copy_keyblock_contents(context->context, 
					      &key->key, &(*new_keys)[i]);
	    if(ret)
		break;
	    *n_keys = i + 1;
	}
	ent.kvno++;
    }
    if(ret)
	goto out2;
    ret = _kadm5_set_modifier(context, &ent);
    if(ret)
	goto out2;

    hdb_seal_keys(context->db, &ent);

    kadm5_log_modify (context,
		      &ent,
		      KADM5_PRINCIPAL | KADM5_MOD_NAME | KADM5_MOD_TIME |
		      KADM5_KEY_DATA | KADM5_KVNO);

    ret = context->db->store(context->context, context->db, 
			     HDB_F_REPLACE, &ent);
out2:
    hdb_free_entry(context->context, &ent);
out:
    context->db->close(context->context, context->db);
    if(ret){
	int i;
	for(i = 0; i < *n_keys; i++)
	    krb5_free_keyblock_contents(context->context, &(*new_keys)[i]);
	free(*new_keys);
	*n_keys = 0;
    }
    return _kadm5_error_code(ret);
}

