/*
 *	$Source: /mit/kerberos/src/appl/erlogin/RCS/envoob.c,v $
 *	$Author: jtkohl $
 *	$Header: envoob.c,v 4.2 88/03/17 10:35:21 jtkohl Exp $
 */

#ifndef lint
static char *rcsid_envoob_c = "$Header: envoob.c,v 4.2 88/03/17 10:35:21 jtkohl Exp $";
#endif lint

/*
 * Copyright (c) 1983 Regents of the University of California.
 * Changes Copyright (c) 1987 Massachusetts Institute of Technology.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char sccsid[] = "@(#)envoob.c	5.10 (Berkeley) 3/30/86";
#endif not lint

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <stdio.h>
#include <sgtty.h>
#include <netdb.h>
#include <errno.h>
#include <signal.h>
#include <strings.h>
#include <sys/time.h>
#include "fifo.h"

extern FILE	*dbg;
extern int	errno;
extern int	flush_to_oob_mark();
extern char*	malloc();
extern char*	getenv();

int	daemon_env_oob();
int	stop_waiting_for_env();

char*	login_env[2] = { NULL, NULL };

/*
 *    When rlogind passes a pty control byte to rlogin,
 * rlogin treats the byte as a bit-vector.
 * In other contexts, we're free to treat the oob-char as a number,
 * so the RLOGIN_ macros do not just name single bits.
 * Nevertheless, for compatibility, these avoid bits 0-5, which TIOCPKT_ uses.
 * RLOGIN_ENVIRONMENT_VAR sets the TIOCPKT_WINDOW bit, but rlogin never
 * receives R'VAR, so R'VAR doesn't confuse rlogin's oob-handler.
 */

/* TBD: these should use the lower bits, not the upper ones */
#define RLOGIN_ENVIRONMENT_OK	0x40
#define RLOGIN_ENVIRONMENT_VAR	0xc0

/*
 * client-side (rlogin) code.
 */
#ifdef CLIENT

int	ext_rem;	/* for oob-handler's use */

setup_env(rem) int rem; {
	ext_rem = rem;
}

char buf[ BUFSIZ] = "  DISPLAY=";

sendenv() {
	struct hostent *hp;
	char *dpy, *machname, *suffix = (char *) 0;
	char oob_char = RLOGIN_ENVIRONMENT_OK;
	int len;

	DBG_FPRINTF((dbg, ">>sendenv\n"));

	send( ext_rem, &oob_char, 1, MSG_OOB); /* acknowledge request */

	dpy = getenv("DISPLAY");	/* eg, "machinename:0" */
	/* 
	  we should flag the user that his DISPLAY is garbage if it doesn't
	  look like an X display variable, but we don't have control of
	  the terminal (The reader process does.)
	 */

	if (dpy && (suffix = rindex( dpy, ':')))
		*(suffix++) = '\0';	/* cut off the suffix */

	/* for X efficiency, some users set their local DISPLAY var to UNIX:0 .
	 * construct a more useful DISPLAY value for these people.
	 */
	if ((dpy == NULL) || (*dpy == '\0') || !strcmp(dpy, "unix")) {
		len = strlen( buf);
		gethostname( buf + len, sizeof buf - len);
	}
	else strcat( buf, dpy);
	machname = index( buf, '=') + 1;

	/* If display is a recognized type, 
	 * "canonicalize" the machine-name: get the official version.
	 */
	if (suffix) {
		if (hp = gethostbyname(machname))
			strcpy(machname, hp->h_name);

		strcat( buf, ":");
		strcat( buf, suffix);
	}

	/* line format is: <len of name=val>,"name=val" */
	len = strlen(buf);
	*(short *)buf = htons(len - 2);	/* don't count length field */
	write(ext_rem, buf, len);

	/* TO BE DONE: get more var's from .envrc file
	pathname = strcat (getenv("HOME"), "/.envrc");
	rc = open(pathname, O_RDONLY);
	if (rc < 0) return;
	*/

	/* dbg: this message is unnecessary.
	*buf = RLOGIN_ENVIRONMENT_OK;
	send(ext_rem, buf, 1, MSG_OOB);	/* end-of-data oob-mark */

	DBG_FPRINTF((dbg, "<<sendenv\n"));
}
/* end client's code */

#endif CLIENT

#ifdef SERVER

/*
 * server-side (rlogind) code.
 */

/*
 * # seconds for server to wait for incoming environment-offer,
 * before giving up.
 */
#define	ENV_WAIT 30

/* # microseconds for server to wait after completing the environment-
 * transfer, before requesting window-sizes. a delay is necessary
 * because the client's kernel can't queue incoming oob-messages;
 * thus, the server's winsize-request would collide with its environ-ack.
 * ideally, this delay should be estimated from how much of ENV_WAIT
 * is actually used.
 */
#define OOB_DELAY 250000
struct timeval delay = { 0, OOB_DELAY };

extern int netf, pty;	/* static copies of the daemon's device-descriptors. */

char** req_and_await_env(f, p) int f, p; {
	/* ask modern rlogin to send us environment var's.
	 * the message, if any, will arrive out-of-band.
	 * set up handlers, and temporarily unblock SIGURG's.
	 * if a SIGURG is waiting, it will arrive immediately,
	 * so that daemon_env_oob() executes.
	 * if no SIGURG arrives within ENV_WAIT seconds, give up.
	 */
	char buf = RLOGIN_ENVIRONMENT_OK;

	netf = f; pty = p;
	send(f, &buf, 1, MSG_OOB);

	signal(SIGURG, daemon_env_oob);
	signal(SIGALRM, stop_waiting_for_env);

	alarm(ENV_WAIT);
	sigpause(0);	/* temporarily allow all signals */

	return(login_env);
}

char* timeoutmsg[] = {
 "\r\n",
 "Sorry, but rlogin can't pass your DISPLAY environment-variable\r\n",
 "to your remote session. If you're logging in across a great\r\n",
 "net-distance, or if your local host is running 4.3bsd UNIX (or older),\r\n",
 "retrying rlogin won't help.\r\n",
 "After you see a command-prompt, you'll have to set DISPLAY yourself.\r\n",
 "To do this, use the command: setenv DISPLAY your-workstation-name:0\r\n",
 "\r\n"
 };

/* if the environment oob-msg never comes from rlogin,
 * we need to get past the sigpause. this handler defuses the SIGALRM.
 */
stop_waiting_for_env() {
	int i;
	DBG_FPRINTF((dbg, ">>stop_waiting.\n"));
	for (i = 0; i < sizeof(timeoutmsg)/4 ; i++)
		write(netf, timeoutmsg[i], strlen(timeoutmsg[i]) + 1);
	DBG_FPRINTF((dbg, "<<stop_waiting.\n"));
}

daemon_env_oob() {
	int cc, len;
	unsigned char *buf, mark;

	DBG_FPRINTF((dbg, ">>env_oob\n"));
	alarm(0);		/* reset so doit won't wait after we return */

	signal(SIGURG, SIG_IGN); /* only other oob heralds window-sizes; */
				 /* we haven't asked for them yet, so we */
				 /* know that their oob isn't coming.    */

	/* If we get the out-of-band msg RLOGIN_ENVIRONMENT_OK, we know
	 * rlogin is prepared to send us the user's desired environment.
	 * There are data on the socket, which login is expecting to see,
	 * and which, under 4.3bsd, the protocol() process transferred
	 * to the pty automatically.
	 * We have to transfer these data now, before we can take the
	 * environment stuff off the socket. I admit it, this is ugly.
	 * my excuse: it WOULD be cleaner if rlogind always flushed
	 *	this stuff before allowing SIGURG's and forking,
	 *	but since we can't know whether a kerberos ticket is coming,
	 *	the oob-mark is our only indication of the preamble's end.
	 */

	flush_to_oob_mark(netf, pty);

	if (0 >= recv(netf, &mark, 1, MSG_OOB))
		fatalperror(netf, "recv", errno);

	switch (mark) {
	case RLOGIN_ENVIRONMENT_OK:

		/* send(netf, &mark, 1, MSG_OOB); */

		/* TO BE DONE: link incoming strings into a list
		 * read name into name buffer+4. max env word-len is 1020.
		 * read value into value buffer.
		 * alloc string big enough for name=value\0 & next-ptr.
		 * copy name, '=',  and value buffers into alloc'd string.
		 * put this string's addr into previous string's 1st 4 bytes.
		 * bump string-counter.
		 * alloc vector big enough to hold all list elements+NULL.
		 * copy element-pointers+4 into vector.
		 */
		cc = read(netf, &len, 2); /* get length first */
		len = ntohs(len);
		/*
		 * allocate room for list-ptr & '\0'
		 */
		buf = (unsigned char *) malloc(len + 5);
		buf[len+4] = '\0';
		cc = read(netf, buf + 4, len);
		login_env[0] = (char*)buf + 4;

		DBG_FPRINTF((dbg, "envoob: string rec'd. len= %d string= %s\n",
			len, buf+4));
		break;
	default: break;
	}
	select( 0, &cc, &cc, &cc, &delay); /* use cc as a dummy temp */
	DBG_FPRINTF((dbg, "<<env_oob\n"));
}
#endif SERVER
/* end server's code */
