.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/KRB_ERROR_spec.ms,v $
.\"	$Author: jtkohl $
.\"	$Id: KRB_ERROR_spec.ms,v 1.19 90/12/19 17:06:23 jtkohl Exp $
.\"
.ds R# "$Id: KRB_ERROR_spec.ms,v 1.19 90/12/19 17:06:23 jtkohl Exp $
.N: sec 2 foo39 "Error message specification"
.PP
This section specifies the format for the KRB_ERROR message.  The
fields included in the message are intended to return as much
information as possible about an error.  It is not expected that all
the information required by the fields will be available for all types
of errors.  If the appropriate information is not available when the
message is composed, the corresponding field
will be left out of the message.
.PP
Note that since the KRB_ERROR message is not protected by any encryption, it is
quite possible for an intruder to synthesize or modify such a message.
In particular, this means that the client should \fBnot\fP use any
fields in this message for security-critical purposes, such as setting a
system clock or generating a fresh authenticator.  The message can be
useful, however, for advising a user on the reason for some failure.
.N: sec 3 krb_error_def "KRB_ERROR definition"
.PP
The KRB_ERROR message consists of the following fields:
.TS
center;
lb l l.
KRB-ERROR ::=	[APPLICATION 30] SEQUENCE {
	pvno[0]	INTEGER,
	msg-type[1]	INTEGER,
	ctime[2]	KerberosTime OPTIONAL,
	cusec[3]	INTEGER OPTIONAL,
	stime[4]	KerberosTime,
	susec[5]	INTEGER,
	error-code[6]	INTEGER,
	crealm[7]	Realm OPTIONAL,
	cname[8]	PrincipalName OPTIONAL,
	realm[9]	Realm, -- Correct realm
	sname[10]	PrincipalName, -- Correct name
	e-text[11]	GeneralString OPTIONAL,
	e-data[12]	OCTET STRING OPTIONAL
}
.TE

.IP "\fBpvno\fP and \fBmsg-type\fP" 10
.br
These fields are described above in section ~sec kdc_req_def~.
\fBmsg-type\fP is KRB_ERROR.

.IP \fBctime\fP 10
This field is described above in section ~sec kdc_req_def~.


.IP \fBcusec\fP 10
This field is described above in section ~sec ap_rep_def~.

.IP \fBstime\fP 10
This field contains the current time on the server.  It is of
type KerberosTime.

.IP \fBsusec\fP 10
This field contains the microsecond part of the server's timestamp.
Its value ranges from 0 to 999.  It appears along with \fBstime\fP. The
two fields are used in conjunction to specify a reasonably accurate timestamp.

.IP \fBerror-code\fP 10
This field contains the error code returned by Kerberos or the server
when a request fails.  To interpret the value of this field see the list
of error codes in section ~sec constants~.  Implementations are
encouraged to provide for national language support in the display of
error messages.

.IP "\fBcrealm, cname, srealm\fP and \fBsname\fP" 10
.br
These fields are described above in section ~sec ticket_def~.

.IP \fBe-text\fP 10
This field contains additional text to help explain the error code
associated with the failed request (for example, it might include a
principal name which was unknown).

.IP \fBe-data\fP 10
This field contains additional data about the error for use by the
application to help it recover from or handle the error.  If the
\fBerror-code\fP is KRB_AP_ERR_METHOD, then the e-data field will
contain an encoding of the following sequence:
.TS
center;
lb l l.
METHOD-DATA ::=	SEQUENCE {
	method-type[0]	INTEGER,
	method-data[1]	OCTET STRING OPTIONAL
}
.TE
\fBmethod-type\fP will indicate the required alternate method;
\fBmethod-data\fP will contain any required additional information.
