/* ofb64_enc.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the libdes distribution for more details.
 */

#include "des_locl.h"

/* The input and output encrypted as though 64bit ofb mode is being
 * used.  The extra state information to record how much of the
 * 64bit block we have used is contained in *num;
 */
int des_ofb64_encrypt(in,out,length,schedule,ivec,num)
register unsigned char *in,*out;
long length;
des_key_schedule schedule;
des_cblock *ivec;
int *num;
	{
	register unsigned long v0,v1;
	register int n=*num;
	register long l=length;
	des_cblock d;
	register char *dp;
	unsigned long ti[2];
	unsigned char *iv;
	int save=0;

	iv=(unsigned char *)ivec;
	c2l(iv,v0);
	c2l(iv,v1);
	ti[0]=v0;
	ti[1]=v1;
	dp=(char *)d;
	l2c(v0,dp);
	l2c(v1,dp);
	while (l--)
		{
		if (n == 0)
			{
			des_encrypt((unsigned long *)ti,(unsigned long *)ti,
				schedule,DES_ENCRYPT);
			dp=(char *)d;
			l2c(ti[0],dp);
			l2c(ti[1],dp);
			save++;
			}
		*(out++)=*(in++)^d[n];
		n=(n+1)&0x07;
		}
	if (save)
		{
		v0=ti[0];
		v1=ti[1];
		iv=(unsigned char *)ivec;
		l2c(v0,iv);
		l2c(v1,iv);
		}
	v0=v1=ti[0]=ti[1]=0;
	*num=n;
	return(0);
	}

