/* getutmpentry.c: The opiegetutmpentry() library function.

Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net Copyright Notice and License Agreement applies to
these portions of the software.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

	History:

	Modified by cmetz for OPIE 2.2. Use FUNCTION declaration, trickery
	      to avoid an ifdef in pututmpentry's declaration. Let Autoconf
              take one last stab at finding utmp/wtmp files. Ifdef around
              some headers.
        Modified at NRL for OPIE 2.2. Moved into different name and subdir.
	Modified at NRL for OPIE 2.1. Added HPUX PTY fixes.
	Written at NRL for OPIE 2.0.
*/

#include "opie_cfg.h"

#include <stdio.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <fcntl.h>
#include <utmp.h>
#if HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */
#include <time.h>

#include "opie.h"

#if DOUTMPX
#include <utmpx.h>
#endif	/* DOUTMPX */

#ifndef _PATH_UTMP
#ifdef UTMP_FILE
#define _PATH_UTMP	UTMP_FILE
#else /* UTMP_FILE */
#ifdef PATH_UTMP_AC
#define _PATH_UTMP	PATH_UTMP_AC
#else /* PATH_UTMP_AC */
#define _PATH_UTMP       "/etc/utmp"
#endif /* PATH_UTMP_AC */
#endif /* UTMP_FILE */
#endif

#ifndef _PATH_UTMPX
#ifdef PATH_UTMPX_AC
#define _PATH_UTMPX	PATH_UTMPX_AC
#else /* PATH_UTMPX_AC */
#define _PATH_UTMPX     "/etc/utmpx"
#endif /* PATH_UTMPX_AC */
#endif	/* _PATH_UTMPX */

#ifndef DOOURUTMP
#define DOOURUTMP 1
#endif /* DOOURUTMP */

VOIDRET opiegetutmpentry FUNCTION((line, utmp), char *line AND 
				  struct UTMPX *utmp)
{
  struct UTMPX utmp2;
#if DOOURUTMP
  int i = 0, j = 0, f;
#else /* DOOURUTMP */
  struct UTMPX *utmp3;
#endif /* DOOURUTMP */
  char *line2;
#ifdef hpux
  char line3[9];
  strcpy(line3, "pty/\0\0\0\0\0");
#endif /* hpux */

  line2 = line;
  if (!strncmp(line, "/dev/", 5))
    line2 += 5;

#ifdef hpux
  strcpy(line3 + 4, line2);
#endif /* hpux */

#if DOOURUTMP
#if DOUTMPX
  if ((f = open(_PATH_UTMPX, O_RDONLY)) < 0) {
#else	/* DOUTMPX */
  if ((f = open(_PATH_UTMP, O_RDONLY)) < 0) {
#endif	/* DOUTMPX */
    perror("getutmpentry: open");
    return;
  }
  do {
    j = read(f, (char *) &utmp2, sizeof(struct UTMPX));
    if ((j == sizeof(struct UTMPX)) && (!strncmp(utmp2.ut_line, line,
		    sizeof(utmp2.ut_line)) || !strncmp(utmp2.ut_line, line2,
						  sizeof(utmp2.ut_line)))) {
      close(f);
      memcpy(utmp, &utmp2, sizeof(struct UTMPX));
#ifdef DEBUG
      fprintf(stderr, "getutmpentry: Found it!\n");
#endif	/* DEBUG */
      return;
    }
    i++;
  }
  while (j == sizeof(struct UTMPX));

  close(f);

#ifdef DEBUG
  fprintf(stderr, "getutmpentry: No matches\n");
#endif	/* DEBUG */
#else /* DOOURUTMP */
  memset(&utmp2, 0, sizeof(utmp2));

  strncpy(&(utmp2.ut_line), line, sizeof(utmp2.ut_line) - 1);
  utmp2.ut_line[sizeof(utmp2.ut_line) - 1] = 0;
#if DOUTMPX
  if (utmp3 = getutxline(utmp2))
#else /* DOUTMPX */
  if (utmp3 = getutline(utmp2))
#endif /* DOUTMPX */
    goto found;

  strncpy(&(utmp2.ut_line), line2, sizeof(utmp2.ut_line) - 1);
  utmp2.ut_line[sizeof(utmp2.ut_line) - 1] = 0;
#if DOUTMPX
  if (utmp3 = getutxline(utmp2))
#else /* DOUTMPX */
  if (utmp3 = getutline(utmp2))
#endif /* DOUTMPX */
    goto found;

#ifdef hpux
  strncpy(&(utmp2.ut_line), line3, sizeof(utmp2.ut_line) - 1);
  utmp2.ut_line[sizeof(utmp2.ut_line) - 1] = 0;
#if DOUTMPX
  if (utmp3 = getutxline(utmp2))
#else /* DOUTMPX */
  if (utmp3 = getutline(utmp2))
#endif /* DOUTMPX */
    goto found;
#endif /* hpux */

#ifdef DEBUG
  fprintf(stderr, "getutmpentry: No matches\n");
#endif	/* DEBUG */
  return;

 found:
  memcpy(utmp, utmp2, sizeof(utmp));
#ifdef DEBUG
  fprintf(stderr, "getutmpentry: Found it!\n");
#endif	/* DEBUG */
#endif /* DOOURUTMP */
}
