/* unlock.c: The opieunlock() library function.

Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net Copyright Notice and License Agreement applies to
these portions of the software.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

        History:

	Modified by cmetz for OPIE 2.2. Use FUNCTION declaration.
            Check for read() == -1. ifdef around unistd.h.
        Created at NRL for OPIE 2.2 from opiesubr2.c
*/
#include "opie_cfg.h"
#include <string.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <fcntl.h>
#include "opie.h"

extern char *opielockfilename;

/* 
  Just remove the lock, right?
  Well, not exactly -- we need to make sure it's ours. 
*/
int opieunlock FUNCTION_NOARGS
{
#ifdef USER_LOCKING
  int fh, rval = -1, pid, t, i;
  char buffer[128], *c, *c2;

  if (!opielockfilename)
    return -1;

  if (!(fh = open(opielockfilename, O_RDWR, 0600)))
    goto unlockret;

  if ((i = read(fh, buffer, sizeof(buffer))) < 0)
    goto unlockret;

  buffer[sizeof(buffer) - 1] = 0;
  buffer[i - 1] = 0;

  if (!(c = strchr(buffer, '\n')))
    goto unlockret;

  *(c++) = 0;

  if (!(c2 = strchr(c, '\n')))
    goto unlockret;

  *(c2++) = 0;

  if (!(pid = atoi(buffer)))
    goto unlockret;

  if (!(t = atoi(c)))
    goto unlockret;

  if ((pid != getpid()) && (time(NULL) + OPIE_LOCK_TIMEOUT <= t) && 
    (!kill(pid, 0))) { 
    rval = 1;
    goto unlockret1;
  }

  rval = 0;

unlockret:
  unlink(opielockfilename);

unlockret1:
  if (fh)
    close(fh);
  free(opielockfilename);
  opielockfilename = NULL;
  return rval;
#else /* USER_LOCKING */
  return 0;
#endif /* USER_LOCKING */
}
