/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

# pragma ident "@(#)certreq.C	1.6 95/11/21"

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <iostream.h>
#include "Bstream.h"
#include "Bigint.h"
#include "SkipCert.h"
#include "certx.h"
#include "skip_certbase.h"
#include "skip_fetchcert.h"

// This is a simple client to the certificate discovery protocol.  It takes
// a keyid, nsid and certificate site and fetches it from the specified remote
// host.

void usage(char *s){
	cerr<<"usage: "<<s<<" [-d] -h server nodeid\n";
	cerr<<"e.g: " << s << " -h skip.incog.com c7beb122\n";
	exit(1);
}

main(int argc,char *argv[])
{
	int n;
	u_char nsid=1;
	Bstream cert, keyid;
	Bigint remote;
	int size=2048;
	struct in_addr *inetaddr;
	u_long i;
	struct hostent *h;
	struct remote_info rem;
	SkipCert *sc;
	extern char *optarg;
	extern int optind;

	char **p;
	char *s;
	int c;
	u_long addr;
	int decodecert=0;
	p=argv;
	p++;
	while ((c=getopt(argc,argv,"dn:h:"))!=EOF)
		switch(c) {
			case 'd':
				p++;
				decodecert=1;
				break;
			case 'n':
				p++,p++;
				nsid=atoi(optarg);
				break;
			case 'h':
				p++,p++;
				s=optarg;		
				break;
			default:
				usage(argv[0]);
		}
	if (s == NULL) {
		usage(argv[0]);
	}
	if ((argc - optind) != 1) {
		usage(argv[0]);
	}

	if (isdigit(*s)) {
		i=inet_addr(s);
		inetaddr=(struct in_addr *)&i;
	} else {
		h=gethostbyname(s);
		if (h==NULL) {
			cerr<<"Unknown Host\n";
			exit(1);
		}
		inetaddr=(struct in_addr *)h->h_addr_list[0];
	}

	keyid=Bigint_to_Bstr(Bigint(*p));
	if (keyid.getlength() != nsid_sizes[nsid]) {
		cerr<<"Size of key("<< keyid.getlength()<<
			") does not match size of NSID" << (int)nsid<< 
			" ("<< nsid_sizes[nsid] <<")\n";
		exit(1);
	}
	String temp;
	if (decodecert) {
		temp=keyid.gethexstr();
		printf("keyid=%s\n",(const char *)temp);
	}
// cdp_get_cert does the actual certificate discovery 
	n=cdp_get_cert(inetaddr, nsid, keyid, &sc);
	switch (n) {
	
		case CDP_STATUS_LOCALERR:
			cerr << "Unable to initiate remote connection\n";
			break;

		case CDP_STATUS_OK:
			if (sc == NULL) {
				cerr << "Certificate Error\n";
				break;
			} if (decodecert) {
				sc->print();
			} else {
				write(1,(char *)sc->encode().getdatap(),
					sc->encode().getlength());
		
			}
			delete sc;
			break;
		case CDP_STATUS_NOTFOUND:
			cerr << "Remote server didn't have the certificate\n";
			break;
		case CDP_STATUS_ERROR:
			cerr << "An error occured on the remote server\n";
			break;
		case CDP_STATUS_NONSID:
			cerr << "The Remote server does not recognize NSID\n";
			break;
		default:
			cerr << "An unknown error occured\n";
			break;
	}
}
