/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)es_systems.c	1.3 95/11/15 Sun Microsystems"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/xv_xrect.h>
#include <xview/notice.h>
#include <skip_types.h>
#include <skip_proto.h>

#include "skiptool_ui.h"
#include "es_glue.h"

#define	NIS_SERVER	"NIS name server"
#define	DNS_SERVER	"DNS name server"
#define	NFS_SERVER	"NFS file server"
#define	BROADCAST_ADDR	"local broadcast address"
#define	LOCAL_ADDR	"local system"
#define	X11_DISPLAY	"X Windows display"

#define	DNS_CONF	"/etc/resolv.conf"
#define	YPWHICH		"/bin/ypwhich -m 2> /dev/null"
#ifdef SYSV
#define	MOUNT		"/usr/sbin/mount -v 2> /dev/null"
#else
#define	MOUNT		"/etc/mount 2> /dev/null"
#endif

#define	BUFSZ		256

boolean_t
es_find_system(es_system_t **syslistp, struct in_addr *addr,
							skip_param_t *entry)
{
	es_system_t	*system, **prevsystem;

	for (prevsystem = syslistp; system = *prevsystem;
						prevsystem = &system->next) {
		if (memcmp((char *) &system->params.ip_addr,
				(char *) addr,
				sizeof (addr)) == 0) {
			/*
			 * found system
			 */
			break;
		}
	}
	if (system == NULL) {
		return (B_FALSE);
	}
	*entry = system->params;
	*prevsystem = system->next;
	free((char *) system);
	return (B_TRUE);
}

void
es_destroy_systems(es_system_t **syslistp)
{
	es_system_t	*next_system;

	for (; *syslistp; *syslistp = next_system) {
		next_system = (*syslistp)->next;
		free((char *) (*syslistp));
	}
}

void
es_list_systems(es_system_t *syslist)
{
	for (; syslist; syslist = syslist->next) {
		printf("%s\t(%s)\n", inet_ntoa(syslist->params.ip_addr),
							syslist->desc);
	}
}

/* es_add_system()
 *
 * Add a system uniquely to the list
 */
void
es_add_system(es_system_t **syslistp, skip_param_t *params, char *desc)
{
	es_system_t	*system, *oldsystem = NULL;

	if (params == NULL) {
		return;
	}

	for (system = *syslistp; system; system = system->next) {
		if (memcmp((char *) &system->params.ip_addr,
				(char *) &params->ip_addr,
				sizeof (params->ip_addr)) == 0) {
			/*
			 * system already present
			 */
			return;
		}
		oldsystem = system;
	}

	/*
	 * add new system
	 */
	system = (es_system_t *) calloc(1, sizeof *system);
	if (system == NULL) {
		return;
	}

	system->desc = desc;	/* XXX must be statically allocated */
	system->params = *params;

	if (oldsystem == NULL) {
		*syslistp = system;
	} else {
		oldsystem->next = system;
	}
}

/*
 * Locate NFS system
 */
void
es_get_nfs_servers(es_system_t **syslistp)
{
	FILE		*pp;
	char		*s, line[BUFSZ];
	skip_param_t	params = { 0 };

	/*
	 * get mount information
	 */
	pp = popen(MOUNT, "r");
	if (!pp) {
		return;
	}
	do {
		if (fgets(line, BUFSZ, pp) == NULL) {
			break;
		}
		s = strtok(line, " \n");

		if (!s || strchr(s, ':') == NULL) {
			continue;
		}
		* strchr(s, ':') = '\0';
		/*
		 * add the file server
		 */
		if (skip_host_to_addr(s, &params.ip_addr) == 0) {
			es_add_system(syslistp, &params, NFS_SERVER);	
		}
	} while (!feof(pp));
	pclose(pp);
}

/*
 * Locate DNS servers
 */
void
es_get_dns_servers(es_system_t **syslistp)
{
	FILE		*fp;
	char		*s, line[BUFSZ];
	skip_param_t	params = { 0 };
	struct hostent	*hp;

	/*
	 * get DNS configuration information
	 */
	fp = fopen(DNS_CONF, "r");
	if (!fp) {
		return;
	}
	do {
		if (fgets(line, BUFSZ, fp) == NULL) {
			break;
		}
		s = strtok(line, " \n");

		if (!s || strcmp(s, "nameserver")) {
			continue;
		}

		s = strtok(NULL, " \n");

		if (!s) {
			continue;
		}
		/*
		 * add the DNS server
		 */
		if (skip_host_to_addr(s, &params.ip_addr) == 0) {
			es_add_system(syslistp, &params, DNS_SERVER);	
		}
	} while (!feof(fp));
	fclose(fp);
}

/*
 * Get local address (4.x only)
 */
void
es_get_local_addr(es_system_t **syslistp)
{
	char			hostname[STRSZ];
	skip_param_t		params = { 0 } ;

#ifdef SYSV
	return;
#else
	gethostname(hostname, STRSZ);
	if (skip_host_to_addr(hostname, &params.ip_addr) < 0) {
		return;
	}
	es_add_system(syslistp, &params, LOCAL_ADDR);	
#endif
}

/*
 * Get local broadcast address
 */
void
es_get_broadcast_addr(es_system_t **syslistp)
{
	struct in_addr		addr;
	skip_param_t		params = { 0 } ;

	if (skip_if_get_broadcast(ifname, &addr) < 0) {
		return;
	}
	params.ip_addr = addr;
	es_add_system(syslistp, &params, BROADCAST_ADDR);	
}

/*
 * Locate NIS name servers
 */
void
es_get_nis_servers(es_system_t **syslistp)
{
	FILE		*pp;
	char		*s, line[BUFSZ];
	skip_param_t	params = { 0 };

	/*
	 * get server for each map
	 */
	pp = popen(YPWHICH, "r");
	if (!pp) {
		return;
	}
	do {
		if (fgets(line, BUFSZ, pp) == NULL) {
			break;
		}
		/*
		 * drop the map name
		 */
		s = strtok(line, " \n");
		/*
		 * get the server name
		 */
		s = strtok(NULL, " \n");
		/*
		 * add the name server
		 */
		if (skip_host_to_addr(s, &params.ip_addr) == 0) {
			es_add_system(syslistp, &params, NIS_SERVER);	
		}
	} while (!feof(pp));
	pclose(pp);
}
/*
 * Locate local X11 display
 */
void
es_get_x11_display(es_system_t **syslistp)
{
	char		*s, line[BUFSZ];
	skip_param_t	params = { 0 };

	s = XDisplayName(NULL);
	if (s == NULL) {
		return;
	}
	if (s[0] == ':') {
		return;
	}
	strcpy(line, s);
	s = strtok(line, ":");
	if (skip_host_to_addr(s, &params.ip_addr) == 0) {
		es_add_system(syslistp, &params, X11_DISPLAY);	
	}
}
