/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
/*
 * skiptool_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `skiptool.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include "skiptool_ui.h"

/*
 * Create object `stats_menu' in the specified instance.
 */
Xv_opaque
skiptool_stats_menu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	skiptool_stats_menu_item0_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_stats_menu_item1_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_stats_menu_item2_callback(Menu_item, Menu_generate);
	extern Menu_item	skiptool_stats_menu_item3_callback(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, owner ? "" : "SKIP Statistics",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Interface Stats",
			MENU_GEN_PROC, skiptool_stats_menu_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Header Stats",
			MENU_GEN_PROC, skiptool_stats_menu_item1_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Algorithm Stats",
			MENU_GEN_PROC, skiptool_stats_menu_item2_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Key Stats",
			MENU_GEN_PROC, skiptool_stats_menu_item3_callback,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "SKIP Statistics",
		NULL);
	return obj;
}

/*
 * Create object `menu' in the specified instance.
 */
Xv_opaque
skiptool_menu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	skiptool_menu_item0_callback(Menu_item, Menu_generate);
	extern Xv_opaque	skiptool_stats_menu_create(caddr_t, Xv_opaque);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, owner ? "" : "File",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Key Management...",
			MENU_GEN_PROC, skiptool_menu_item0_callback,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "SKIP Statistics",
			MENU_PULLRIGHT, skiptool_stats_menu_create(ip, owner),
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save",
			MENU_INACTIVE, TRUE,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "File",
		NULL);
	return obj;
}

/*
 * Create object `help_menu' in the specified instance.
 */
Xv_opaque
skiptool_help_menu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	skiptool_help_menu_item1_callback(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, owner ? "" : "Help",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Help items",
			MENU_INACTIVE, TRUE,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "About...",
			MENU_GEN_PROC, skiptool_help_menu_item1_callback,
			NULL,
		MENU_DEFAULT, 3,
		MENU_GEN_PIN_WINDOW, owner, "Help",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `base_window'.
 */
skiptool_base_window_objects *
skiptool_base_window_objects_initialize(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_base_window_objects *) calloc(1, sizeof (skiptool_base_window_objects))))
		return (skiptool_base_window_objects *) NULL;
	if (!ip->base_window)
		ip->base_window = skiptool_base_window_base_window_create(ip, owner);
	if (!ip->controls6)
		ip->controls6 = skiptool_base_window_controls6_create(ip, ip->base_window);
	if (!ip->settings_button)
		ip->settings_button = skiptool_base_window_settings_button_create(ip, ip->controls6);
	if (!ip->help_button)
		ip->help_button = skiptool_base_window_help_button_create(ip, ip->controls6);
	if (!ip->controls1)
		ip->controls1 = skiptool_base_window_controls1_create(ip, ip->base_window);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_base_window_skip_icon_create(ip, ip->controls1);
	if (!ip->system_status)
		ip->system_status = skiptool_base_window_system_status_create(ip, ip->controls1);
	if (!ip->access_ctrl)
		ip->access_ctrl = skiptool_base_window_access_ctrl_create(ip, ip->controls1);
	if (!ip->message6)
		ip->message6 = skiptool_base_window_message6_create(ip, ip->controls1);
	if (!ip->access_mode)
		ip->access_mode = skiptool_base_window_access_mode_create(ip, ip->controls1);
	if (!ip->message12)
		ip->message12 = skiptool_base_window_message12_create(ip, ip->controls1);
	if (!ip->remote_panel)
		ip->remote_panel = skiptool_base_window_remote_panel_create(ip, ip->base_window);
	if (!ip->hostlist)
		ip->hostlist = skiptool_base_window_hostlist_create(ip, ip->remote_panel);
	if (!ip->controls8)
		ip->controls8 = skiptool_base_window_controls8_create(ip, ip->base_window);
	if (!ip->add_host_button1)
		ip->add_host_button1 = skiptool_base_window_add_host_button1_create(ip, ip->controls8);
	if (!ip->delete_button)
		ip->delete_button = skiptool_base_window_delete_button_create(ip, ip->controls8);
	if (!ip->key_status)
		ip->key_status = skiptool_base_window_key_status_create(ip, ip->controls8);
	return ip;
}

/*
 * Create object `base_window' in the specified instance.
 */
Xv_opaque
skiptool_base_window_base_window_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	base_window_image;
#include "skiptool_small.xbm"
	
	base_window_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, skiptool_small_bits,
		XV_WIDTH, skiptool_small_width,
		XV_HEIGHT, skiptool_small_height,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 362,
		XV_HEIGHT, 454,
		XV_LABEL, "SKIP for Solaris ()",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, base_window_image,
			XV_LABEL, "skip",
			NULL),
		NULL);
	return obj;
}

/*
 * Create object `controls6' in the specified instance.
 */
Xv_opaque
skiptool_base_window_controls6_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 33,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `settings_button' in the specified instance.
 */
Xv_opaque
skiptool_base_window_settings_button_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern Xv_opaque	skiptool_menu_create(caddr_t, Xv_opaque);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 8,
		PANEL_LABEL_STRING, "File",
		PANEL_ITEM_MENU, skiptool_menu_create((caddr_t) ip, ip->base_window),
		NULL);
	return obj;
}

/*
 * Create object `help_button' in the specified instance.
 */
Xv_opaque
skiptool_base_window_help_button_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern Xv_opaque	skiptool_help_menu_create(caddr_t, Xv_opaque);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 282,
		XV_Y, 8,
		PANEL_LABEL_STRING, "Help",
		PANEL_ITEM_MENU, skiptool_help_menu_create((caddr_t) ip, ip->base_window),
		NULL);
	return obj;
}

/*
 * Create object `controls1' in the specified instance.
 */
Xv_opaque
skiptool_base_window_controls1_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, (int)xv_get(ip->controls6, XV_Y) +
		      (int)xv_get(ip->controls6, XV_HEIGHT),
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 145,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_base_window_skip_icon_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "skiptool_small.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, skiptool_small_bits,
		XV_WIDTH, skiptool_small_width,
		XV_HEIGHT, skiptool_small_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 22,
		XV_Y, 12,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `system_status' in the specified instance.
 */
Xv_opaque
skiptool_base_window_system_status_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 104,
		XV_Y, 36,
		PANEL_LABEL_STRING, "0 systems authorized to connect",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `access_ctrl' in the specified instance.
 */
Xv_opaque
skiptool_base_window_access_ctrl_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_access_ctrl_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 186,
		XV_Y, 72,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_base_window_access_ctrl_notify_callback,
		PANEL_CHOICE_STRINGS,
			"disabled",
			"enabled",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `message6' in the specified instance.
 */
Xv_opaque
skiptool_base_window_message6_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 77,
		PANEL_LABEL_STRING, "Access control is:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `access_mode' in the specified instance.
 */
Xv_opaque
skiptool_base_window_access_mode_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_access_mode_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 186,
		XV_Y, 104,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_base_window_access_mode_notify_callback,
		PANEL_CHOICE_STRINGS,
			"No access",
			"Ask for confirmation",
			"Add automatically",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `message12' in the specified instance.
 */
Xv_opaque
skiptool_base_window_message12_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 108,
		PANEL_LABEL_STRING, "Unauthorized systems:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `remote_panel' in the specified instance.
 */
Xv_opaque
skiptool_base_window_remote_panel_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 175,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 236,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `hostlist' in the specified instance.
 */
Xv_opaque
skiptool_base_window_hostlist_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern int		systems_list_notify(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
	Xv_opaque	obj;
	Xv_opaque	hostlist_image0;
#include "none.xbm"
	
	hostlist_image0 = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, none_bits,
		XV_WIDTH, none_width,
		XV_HEIGHT, none_height,
		NULL);
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 22,
		XV_Y, 18,
		PANEL_LIST_WIDTH, 300,
		PANEL_LIST_DISPLAY_ROWS, 7,
		PANEL_LABEL_STRING, "Authorized Systems List:",
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_NOTIFY_PROC, systems_list_notify,
		PANEL_LIST_STRINGS,
			"",
			NULL,
		PANEL_LIST_ROW_HEIGHT, 47,
		PANEL_LIST_GLYPH, 0, hostlist_image0,
		NULL);
	return obj;
}

/*
 * Create object `controls8' in the specified instance.
 */
Xv_opaque
skiptool_base_window_controls8_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 408,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `add_host_button1' in the specified instance.
 */
Xv_opaque
skiptool_base_window_add_host_button1_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_add_host_button1_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 46,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Add...",
		PANEL_NOTIFY_PROC, skiptool_base_window_add_host_button1_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `delete_button' in the specified instance.
 */
Xv_opaque
skiptool_base_window_delete_button_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_delete_button_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 132,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Delete",
		PANEL_NOTIFY_PROC, skiptool_base_window_delete_button_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `key_status' in the specified instance.
 */
Xv_opaque
skiptool_base_window_key_status_create(skiptool_base_window_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_base_window_key_status_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 226,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Key status...",
		PANEL_INACTIVE, TRUE,
		PANEL_NOTIFY_PROC, skiptool_base_window_key_status_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `hostwin'.
 */
skiptool_hostwin_objects *
skiptool_hostwin_objects_initialize(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_hostwin_objects *) calloc(1, sizeof (skiptool_hostwin_objects))))
		return (skiptool_hostwin_objects *) NULL;
	if (!ip->hostwin)
		ip->hostwin = skiptool_hostwin_hostwin_create(ip, owner);
	if (!ip->controls3)
		ip->controls3 = skiptool_hostwin_controls3_create(ip, ip->hostwin);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_hostwin_skip_icon_create(ip, ip->controls3);
	if (!ip->hostaddr)
		ip->hostaddr = skiptool_hostwin_hostaddr_create(ip, ip->controls3);
	if (!ip->secure)
		ip->secure = skiptool_hostwin_secure_create(ip, ip->controls3);
	if (!ip->message1)
		ip->message1 = skiptool_hostwin_message1_create(ip, ip->controls3);
	if (!ip->skip_mode)
		ip->skip_mode = skiptool_hostwin_skip_mode_create(ip, ip->controls3);
	if (!ip->message7)
		ip->message7 = skiptool_hostwin_message7_create(ip, ip->controls3);
	if (!ip->r_nsid)
		ip->r_nsid = skiptool_hostwin_r_nsid_create(ip, ip->controls3);
	if (!ip->r_nsid_msg)
		ip->r_nsid_msg = skiptool_hostwin_r_nsid_msg_create(ip, ip->controls3);
	if (!ip->key_id)
		ip->key_id = skiptool_hostwin_key_id_create(ip, ip->controls3);
	if (!ip->controls9)
		ip->controls9 = skiptool_hostwin_controls9_create(ip, ip->hostwin);
	if (!ip->s_nsid)
		ip->s_nsid = skiptool_hostwin_s_nsid_create(ip, ip->controls9);
	if (!ip->s_nsid_msg)
		ip->s_nsid_msg = skiptool_hostwin_s_nsid_msg_create(ip, ip->controls9);
	if (!ip->controls10)
		ip->controls10 = skiptool_hostwin_controls10_create(ip, ip->hostwin);
	if (!ip->kij_alg)
		ip->kij_alg = skiptool_hostwin_kij_alg_create(ip, ip->controls10);
	if (!ip->kp_alg_msg)
		ip->kp_alg_msg = skiptool_hostwin_kp_alg_msg_create(ip, ip->controls10);
	if (!ip->kp_alg)
		ip->kp_alg = skiptool_hostwin_kp_alg_create(ip, ip->controls10);
	if (!ip->kij_alg_msg)
		ip->kij_alg_msg = skiptool_hostwin_kij_alg_msg_create(ip, ip->controls10);
	if (!ip->mac_alg)
		ip->mac_alg = skiptool_hostwin_mac_alg_create(ip, ip->controls10);
	if (!ip->message10)
		ip->message10 = skiptool_hostwin_message10_create(ip, ip->controls10);
	if (!ip->comp_alg)
		ip->comp_alg = skiptool_hostwin_comp_alg_create(ip, ip->controls10);
	if (!ip->message11)
		ip->message11 = skiptool_hostwin_message11_create(ip, ip->controls10);
	if (!ip->controls7)
		ip->controls7 = skiptool_hostwin_controls7_create(ip, ip->hostwin);
	if (!ip->hostwin_apply)
		ip->hostwin_apply = skiptool_hostwin_hostwin_apply_create(ip, ip->controls7);
	if (!ip->hostwin_cancel)
		ip->hostwin_cancel = skiptool_hostwin_hostwin_cancel_create(ip, ip->controls7);
	return ip;
}

/*
 * Create object `hostwin' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_hostwin_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 327,
		XV_HEIGHT, 438,
		XV_LABEL, "Add system...",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls3' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_controls3_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_skip_icon_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "skiptool_small.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, skiptool_small_bits,
		XV_WIDTH, skiptool_small_width,
		XV_HEIGHT, skiptool_small_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 12,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `hostaddr' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_hostaddr_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 94,
		XV_Y, 36,
		PANEL_VALUE_DISPLAY_LENGTH, 18,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Hostname:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `secure' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_secure_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_secure_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 94,
		XV_Y, 75,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_hostwin_secure_notify_callback,
		PANEL_CHOICE_STRINGS,
			"Off",
			"On",
			"On (SunScreen compatibility)",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `message1' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_message1_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 80,
		PANEL_LABEL_STRING, "Security:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_mode' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_skip_mode_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 94,
		XV_Y, 100,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRINGS,
			"Whole packet",
			"Data only",
			NULL,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message7' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_message7_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 105,
		PANEL_LABEL_STRING, "Secure:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `r_nsid' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_r_nsid_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_r_nsid_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 94,
		XV_Y, 125,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_hostwin_r_nsid_notify_callback,
		PANEL_CHOICE_STRING, 0, "Not present",
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `r_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_r_nsid_msg_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 130,
		PANEL_LABEL_STRING, "Key ID:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `key_id' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_key_id_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 155,
		PANEL_VALUE_DISPLAY_LENGTH, 34,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "ID:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_INACTIVE, TRUE,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `controls9' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_controls9_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 184,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 100,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `s_nsid' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_s_nsid_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_s_nsid_notify_callback(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 12,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_NOTIFY_PROC, skiptool_hostwin_s_nsid_notify_callback,
		PANEL_CHOICE_STRING, 0, "Not present",
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `s_nsid_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_s_nsid_msg_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 18,
		PANEL_LABEL_STRING, "Local Key ID:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `controls10' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_controls10_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 229,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 158,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kij_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_kij_alg_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 16,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kp_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_kp_alg_msg_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 21,
		PANEL_LABEL_STRING, "Key encryption:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kp_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_kp_alg_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 48,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "none",
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `kij_alg_msg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_kij_alg_msg_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 53,
		PANEL_LABEL_STRING, "Traffic encryption:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `mac_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_mac_alg_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 80,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "Off",
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message10' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_message10_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 85,
		PANEL_LABEL_STRING, "Authentication:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `comp_alg' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_comp_alg_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 164,
		XV_Y, 112,
		PANEL_CHOICE_NCOLS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_STRING, 0, "Off",
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message11' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_message11_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 117,
		PANEL_LABEL_STRING, "Compression:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `controls7' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_controls7_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 383,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `hostwin_apply' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_hostwin_apply_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_hostwin_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 88,
		XV_Y, 18,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_hostwin_hostwin_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `hostwin_cancel' in the specified instance.
 */
Xv_opaque
skiptool_hostwin_hostwin_cancel_create(skiptool_hostwin_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_hostwin_hostwin_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 188,
		XV_Y, 18,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_hostwin_hostwin_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `key_params_win'.
 */
skiptool_key_params_win_objects *
skiptool_key_params_win_objects_initialize(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_key_params_win_objects *) calloc(1, sizeof (skiptool_key_params_win_objects))))
		return (skiptool_key_params_win_objects *) NULL;
	if (!ip->key_params_win)
		ip->key_params_win = skiptool_key_params_win_key_params_win_create(ip, owner);
	if (!ip->controls4)
		ip->controls4 = skiptool_key_params_win_controls4_create(ip, ip->key_params_win);
	if (!ip->skip_key_max_use)
		ip->skip_key_max_use = skiptool_key_params_win_skip_key_max_use_create(ip, ip->controls4);
	if (!ip->message3)
		ip->message3 = skiptool_key_params_win_message3_create(ip, ip->controls4);
	if (!ip->message12)
		ip->message12 = skiptool_key_params_win_message12_create(ip, ip->controls4);
	if (!ip->skip_key_max_idle)
		ip->skip_key_max_idle = skiptool_key_params_win_skip_key_max_idle_create(ip, ip->controls4);
	if (!ip->message14)
		ip->message14 = skiptool_key_params_win_message14_create(ip, ip->controls4);
	if (!ip->message4)
		ip->message4 = skiptool_key_params_win_message4_create(ip, ip->controls4);
	if (!ip->skip_key_max_bytes)
		ip->skip_key_max_bytes = skiptool_key_params_win_skip_key_max_bytes_create(ip, ip->controls4);
	if (!ip->message15)
		ip->message15 = skiptool_key_params_win_message15_create(ip, ip->controls4);
	if (!ip->message2)
		ip->message2 = skiptool_key_params_win_message2_create(ip, ip->controls4);
	if (!ip->key_apply)
		ip->key_apply = skiptool_key_params_win_key_apply_create(ip, ip->controls4);
	if (!ip->key_default)
		ip->key_default = skiptool_key_params_win_key_default_create(ip, ip->controls4);
	if (!ip->key_cancel)
		ip->key_cancel = skiptool_key_params_win_key_cancel_create(ip, ip->controls4);
	return ip;
}

/*
 * Create object `key_params_win' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_key_params_win_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 414,
		XV_HEIGHT, 149,
		XV_LABEL, "Key Management Parameters",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls4' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_controls4_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `skip_key_max_use' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_skip_key_max_use_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 220,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 100,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 30,
		PANEL_INACTIVE, TRUE,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message3' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message3_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 15,
		XV_Y, 17,
		PANEL_LABEL_STRING, "Change transmit keys every:",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message12' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message12_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 18,
		PANEL_LABEL_STRING, "seconds",
		PANEL_LABEL_BOLD, TRUE,
		PANEL_INACTIVE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_key_max_idle' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_skip_key_max_idle_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 220,
		XV_Y, 40,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 10000,
		PANEL_MIN_VALUE, 5,
		PANEL_VALUE, 30,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message14' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message14_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 35,
		XV_Y, 42,
		PANEL_LABEL_STRING, "Delete unused keys after:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message4' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message4_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 42,
		PANEL_LABEL_STRING, "seconds",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_key_max_bytes' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_skip_key_max_bytes_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 220,
		XV_Y, 66,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 10000,
		PANEL_MIN_VALUE, 1,
		PANEL_VALUE, 512,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message15' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message15_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 89,
		XV_Y, 67,
		PANEL_LABEL_STRING, "Transmit at most:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message2' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_message2_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 67,
		PANEL_LABEL_STRING, "kbytes per key",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `key_apply' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_key_apply_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_key_params_win_key_apply_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 85,
		XV_Y, 104,
		PANEL_LABEL_STRING, "Apply",
		PANEL_NOTIFY_PROC, skiptool_key_params_win_key_apply_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `key_default' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_key_default_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_key_params_win_key_default_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 175,
		XV_Y, 104,
		PANEL_LABEL_STRING, "Default",
		PANEL_NOTIFY_PROC, skiptool_key_params_win_key_default_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `key_cancel' in the specified instance.
 */
Xv_opaque
skiptool_key_params_win_key_cancel_create(skiptool_key_params_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 277,
		XV_Y, 104,
		PANEL_LABEL_STRING, "Cancel",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `required_win'.
 */
skiptool_required_win_objects *
skiptool_required_win_objects_initialize(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_required_win_objects *) calloc(1, sizeof (skiptool_required_win_objects))))
		return (skiptool_required_win_objects *) NULL;
	if (!ip->required_win)
		ip->required_win = skiptool_required_win_required_win_create(ip, owner);
	if (!ip->controls5)
		ip->controls5 = skiptool_required_win_controls5_create(ip, ip->required_win);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_required_win_skip_icon_create(ip, ip->controls5);
	if (!ip->required_message)
		ip->required_message = skiptool_required_win_required_message_create(ip, ip->controls5);
	if (!ip->controls11)
		ip->controls11 = skiptool_required_win_controls11_create(ip, ip->required_win);
	if (!ip->message5)
		ip->message5 = skiptool_required_win_message5_create(ip, ip->controls11);
	if (!ip->message13)
		ip->message13 = skiptool_required_win_message13_create(ip, ip->controls11);
	if (!ip->required_list)
		ip->required_list = skiptool_required_win_required_list_create(ip, ip->controls11);
	if (!ip->controls12)
		ip->controls12 = skiptool_required_win_controls12_create(ip, ip->required_win);
	if (!ip->required_add)
		ip->required_add = skiptool_required_win_required_add_create(ip, ip->controls12);
	if (!ip->required_cancel)
		ip->required_cancel = skiptool_required_win_required_cancel_create(ip, ip->controls12);
	return ip;
}

/*
 * Create object `required_win' in the specified instance.
 */
Xv_opaque
skiptool_required_win_required_win_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 354,
		XV_HEIGHT, 323,
		XV_LABEL, "Required systems",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls5' in the specified instance.
 */
Xv_opaque
skiptool_required_win_controls5_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 78,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_required_win_skip_icon_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "skiptool_small.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, skiptool_small_bits,
		XV_WIDTH, skiptool_small_width,
		XV_HEIGHT, skiptool_small_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 12,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `required_message' in the specified instance.
 */
Xv_opaque
skiptool_required_win_required_message_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 100,
		XV_Y, 36,
		PANEL_LABEL_STRING, "0 addresses currently in use",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `controls11' in the specified instance.
 */
Xv_opaque
skiptool_required_win_controls11_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 71,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 210,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message5' in the specified instance.
 */
Xv_opaque
skiptool_required_win_message5_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 12,
		PANEL_LABEL_STRING, "The addresses below are currently in use and should",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `message13' in the specified instance.
 */
Xv_opaque
skiptool_required_win_message13_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 22,
		XV_Y, 28,
		PANEL_LABEL_STRING, "be added to the access control list:",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `required_list' in the specified instance.
 */
Xv_opaque
skiptool_required_win_required_list_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 22,
		XV_Y, 52,
		PANEL_LIST_WIDTH, 300,
		PANEL_LIST_DISPLAY_ROWS, 6,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_CHOOSE_ONE, FALSE,
		PANEL_CHOOSE_NONE, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `controls12' in the specified instance.
 */
Xv_opaque
skiptool_required_win_controls12_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 278,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `required_add' in the specified instance.
 */
Xv_opaque
skiptool_required_win_required_add_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_required_win_required_add_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 106,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Add",
		PANEL_NOTIFY_PROC, skiptool_required_win_required_add_notify_callback,
		NULL);
	return obj;
}

/*
 * Create object `required_cancel' in the specified instance.
 */
Xv_opaque
skiptool_required_win_required_cancel_create(skiptool_required_win_objects *ip, Xv_opaque owner)
{
	extern void		skiptool_required_win_required_cancel_notify_callback(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 200,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Cancel",
		PANEL_NOTIFY_PROC, skiptool_required_win_required_cancel_notify_callback,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `about_win'.
 */
skiptool_about_win_objects *
skiptool_about_win_objects_initialize(skiptool_about_win_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (skiptool_about_win_objects *) calloc(1, sizeof (skiptool_about_win_objects))))
		return (skiptool_about_win_objects *) NULL;
	if (!ip->about_win)
		ip->about_win = skiptool_about_win_about_win_create(ip, owner);
	if (!ip->controls2)
		ip->controls2 = skiptool_about_win_controls2_create(ip, ip->about_win);
	if (!ip->skip_icon)
		ip->skip_icon = skiptool_about_win_skip_icon_create(ip, ip->controls2);
	if (!ip->message8)
		ip->message8 = skiptool_about_win_message8_create(ip, ip->controls2);
	return ip;
}

/*
 * Create object `about_win' in the specified instance.
 */
Xv_opaque
skiptool_about_win_about_win_create(skiptool_about_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 250,
		XV_HEIGHT, 88,
		XV_LABEL, "About skiptool",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls2' in the specified instance.
 */
Xv_opaque
skiptool_about_win_controls2_create(skiptool_about_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `skip_icon' in the specified instance.
 */
Xv_opaque
skiptool_about_win_skip_icon_create(skiptool_about_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque	skip_icon_image;
#include "skiptool_small.xbm"
	
	skip_icon_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, skiptool_small_bits,
		XV_WIDTH, skiptool_small_width,
		XV_HEIGHT, skiptool_small_height,
		NULL);
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 14,
		XV_Y, 16,
		PANEL_LABEL_IMAGE, skip_icon_image,
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `message8' in the specified instance.
 */
Xv_opaque
skiptool_about_win_message8_create(skiptool_about_win_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 90,
		XV_Y, 36,
		PANEL_LABEL_STRING, "skiptool version 2.00",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

