#ifndef GABA_DEFINE
struct spki_parse_key
{
  struct command super;
  struct randomness *random;
};
extern struct lsh_class spki_parse_key_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_spki_parse_key_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct spki_parse_key *i = (struct spki_parse_key *) o;
  mark((struct lsh_object *) i->random);
}

struct lsh_class spki_parse_key_class =
{ STATIC_HEADER,
  &command_class, "spki_parse_key", sizeof(struct spki_parse_key),
  do_spki_parse_key_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct handle_key
{
  struct command_continuation super;
  struct keypair ** key;
};
extern struct lsh_class handle_key_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class handle_key_class =
{ STATIC_HEADER,
  &command_continuation_class, "handle_key", sizeof(struct handle_key),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

