#ifndef CLASS_DEFINE
struct connection_service
{
  struct ssh_service super;
  struct alist *global_requests;
  struct alist *channel_types;
  struct connection_startup *start;
};
extern struct lsh_class connection_service_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_connection_service_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connection_service *i = (struct connection_service *) o;
  mark((struct lsh_object *) i->global_requests);
  mark((struct lsh_object *) i->channel_types);
  mark((struct lsh_object *) i->start);
}

struct lsh_class connection_service_class =
{ STATIC_HEADER,
  &ssh_service_class, "connection_service", sizeof(struct connection_service),
  do_connection_service_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct global_request_handler
{
  struct packet_handler super;
  struct alist *global_requests;
};
extern struct lsh_class global_request_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_global_request_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct global_request_handler *i = (struct global_request_handler *) o;
  mark((struct lsh_object *) i->global_requests);
}

struct lsh_class global_request_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "global_request_handler", sizeof(struct global_request_handler),
  do_global_request_handler_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct channel_open_handler
{
  struct packet_handler super;
  struct alist *channel_types;
};
extern struct lsh_class channel_open_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_channel_open_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct channel_open_handler *i = (struct channel_open_handler *) o;
  mark((struct lsh_object *) i->channel_types);
}

struct lsh_class channel_open_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "channel_open_handler", sizeof(struct channel_open_handler),
  do_channel_open_handler_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct channel_open_response
{
  struct channel_open_callback super;
  UINT32 remote_channel_number;
  UINT32 window_size;
  UINT32 max_packet;
};
extern struct lsh_class channel_open_response_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class channel_open_response_class =
{ STATIC_HEADER,
  &channel_open_callback_class, "channel_open_response", sizeof(struct channel_open_response),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct channel_write
{
  struct abstract_write super;
  struct ssh_channel *channel;
};
extern struct lsh_class channel_write_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_channel_write_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct channel_write *i = (struct channel_write *) o;
  mark((struct lsh_object *) i->channel);
}

struct lsh_class channel_write_class =
{ STATIC_HEADER,
  &abstract_write_class, "channel_write", sizeof(struct channel_write),
  do_channel_write_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct channel_write_extended
{
  struct channel_write super;
  UINT32 type;
};
extern struct lsh_class channel_write_extended_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class channel_write_extended_class =
{ STATIC_HEADER,
  &channel_write_class, "channel_write_extended", sizeof(struct channel_write_extended),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct channel_close_callback
{
  struct close_callback super;
  struct ssh_channel *channel;
};
extern struct lsh_class channel_close_callback_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_channel_close_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct channel_close_callback *i = (struct channel_close_callback *) o;
  mark((struct lsh_object *) i->channel);
}

struct lsh_class channel_close_callback_class =
{ STATIC_HEADER,
  &close_callback_class, "channel_close_callback", sizeof(struct channel_close_callback),
  do_channel_close_callback_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

