/****************************************************************************
*                                                                           *
* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY     *
* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE       *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR     *
* PURPOSE.                                                                  *
*                                                                           *
* Copyright (C) 1993-95  Microsoft Corporation.  All Rights Reserved.       *
*                                                                           *
****************************************************************************/

/******************************************************************************
 *
 *   Title:	vmcpd.h
 *
 *   Version:	4.00
 *
 ******************************************************************************/

/*INT32*/

#define MK_Shift 2 //	equ 00000010b
#define MK_Ctrl  4 //	equ 00000100b
#define MK_Alt	 8 //	equ 00001000b
#define MK_Extended //128	equ 10000000b



/*XLATOFF*/
#define	VKD_Service	Declare_Service
#pragma warning (disable:4003)		// turn off not enough params warning
/*XLATON*/

/*MACROS*/
Begin_Service_Table(VKD)


VKD_Service	(VKD_Get_Version, LOCAL)
VKD_Service	(VKD_Define_Hot_Key, LOCAL)
VKD_Service	(VKD_Remove_Hot_Key, LOCAL)
VKD_Service	(VKD_Local_Enable_Hot_Key, LOCAL)
VKD_Service	(VKD_Local_Disable_Hot_Key, LOCAL)
VKD_Service	(VKD_Reflect_Hot_Key, LOCAL)
VKD_Service	(VKD_Cancel_Hot_Key_State, LOCAL)
VKD_Service	(VKD_Force_Keys, LOCAL)
VKD_Service	(VKD_Get_Kbd_Owner, LOCAL)
VKD_Service	(VKD_Define_Paste_Mode, LOCAL)
VKD_Service	(VKD_Start_Paste, LOCAL)
VKD_Service	(VKD_Cancel_Paste, LOCAL)
VKD_Service	(VKD_Get_Msg_Key, LOCAL)
VKD_Service	(VKD_Peek_Msg_Key, LOCAL)
VKD_Service	(VKD_Flush_Msg_Key_Queue, LOCAL)
VKD_Service	(VKD_Enable_Keyboard,LOCAL)
VKD_Service	(VKD_Disable_Keyboard,LOCAL)
VKD_Service	(VKD_Get_Shift_State,LOCAL)
VKD_Service	(VKD_Filter_Keyboard_Input)
VKD_Service	(VKD_Put_Byte)
VKD_Service	(VKD_Set_Shift_State,LOCAL)


End_Service_Table (VKD)



//VKD_Define_Hot_Key flags:

#define CallOnPress 1		//; Call call-back when key press is detected
#define CallOnRelease	2		//; Call call-back when key release is detected
							//; (keyboard may still be in hot-key hold state)
#define CallOnRepeat	4		//; Call call-back when repeated press is detected
#define CallOnComplete	8		//; Call call-back when the hot key state is
							//; ended (all shift modifier keys are released)
							//; or when a different hot key is entered
							//; (i.e. pressing ALT 1 2, if both ALT-1
							//;  and ALT-2 are defined hot keys, then ALT-1's
							//;  call back will be called before ALT-2's to
							//;  indicate that the ALT-1 is complete even
							//;  though the ALT key is still down)
#define CallOnUpDwn	CallOnPress+CallOnRelease
							//; Call call-back on both press and release
#define CallOnAll	0			//; Call call-back on press, release, auto-repeat
							//; and complete
#define PriorityNotify  0x10 	//; notification calls to the call-back can only
							//; happen when interrupts are enabled and
							//; the critical section is un-owned
#define Monitor_Key	 0x40		//; New for Windows 4.0
							//; Automatically reflect the hotkey.
#define Local_Key	0x80 		//; key can be locally enabled/disabled


/*ENDMACROS*/

/*XLATOFF*/
#pragma warning (default:4003)		// turn on not enough params warning
/*XLATON*/
