.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/CS.ms,v $
.\"	$Author: jtkohl $
.\"	$Header: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/CS.ms,v 1.40 91/02/18 11:44:20 jtkohl Exp $
.\"
.ds R# "$Id: CS.ms,v 1.40 91/02/18 11:44:20 jtkohl Exp $
.N: sec 2 foo10 "The Client/Server Authentication Exchange"
.TS
center;
c s s
l l l.
Summary
\fIMessage direction	Message type	Section\fR
Client to Application server 	KRB_AP_REQ	~sec ap_req_def~
[optional] Application server to client	KRB_AP_REP or	~sec ap_rep_def~
	KRB_ERROR	~sec krb_error_def~
.TE
.PP
The client/server authentication (CS) exchange is used by network
applications to authenticate the
client to the server and vice versa.  The client must have already
acquired credentials for the server using the AS or TGS
exchange.
.N: sec 3 foo11 "The KRB_AP_REQ message"
.PP
The KRB_AP_REQ contains authentication information which should be 
part of the first message in an authenticated
transaction.  It contains a ticket, an authenticator, and some
additional bookkeeping information (see section ~sec ap_req_def~ for the exact
format).  The ticket by itself is insufficient to authenticate a client,
since tickets are passed across the network in cleartext\**,
.FS
Tickets contain both an encrypted and unencrypted portion, so
cleartext here refers to the entire unit, which can be copied from one
message and replayed in another without any cryptographic skill.
.FE
so the authenticator is used to prevent invalid replay of tickets by proving to
the server that the client knows the session key of the ticket and thus
is entitled to use it.
The KRB_AP_REQ message is referred to elsewhere as the
"authentication header."
.N: sec 3 foo12 "Generation of a KRB_AP_REQ message"
.PP
When a client wishes to initiate authentication to a server, it obtains
(either through a credentials cache, the AS exchange, or the TGS exchange) a
ticket and session key for the desired service.  The client may re-use
any tickets it holds until they expire.
The client then constructs a
new Authenticator from the the system time, its name, and optionally an
application specific checksum, an initial
sequence number to be used in KRB_SAFE or KRB_PRIV messages, and/or a
session subkey to be used in negotiations for a session key unique to
this particular session.
Authenticators may not be re-used and will be rejected if replayed to a
server\**.
.FS
Note that this can make applications based on unreliable
transports difficult to code correctly, if the transport might deliver
duplicated messages.  In such cases, XXX.
.FE
If a sequence number is to be included, it should be randomly chosen so
that even after many messages have been exchanged it is not likely to
collide with other sequence numbers in use.
.PP
The client may indicate a requirement of mutual authentication or the
use of a session-key based ticket by setting the appropriate flag(s) in
the ap-options field of the message.
.PP
The
Authenticator is encrypted in the session key and combined with
the ticket to form the KRB_AP_REQ message which is then sent to the
end server along with any additional application-specific information.
See section ~sec ap_req_g_pc~ for pseudocode.
.N: sec 3 foo13 "Receipt of KRB_AP_REQ message"
.PP
Authentication is based on the server's current time of day (clocks
must be loosely synchronized), the authenticator, and the ticket.
Several errors are possible.  If an error occurs, the server is
expected to reply to the client with a KRB_ERROR message.  This
message may be encapsulated in the application protocol if its "raw" form
is not acceptable to the protocol.
The format of error messages is described in section ~sec krb_error_def~.
.PP
The algorithm for verifying authentication information is as follows.
If the message type is not KRB_AP_REQ, the
server returns the KRB_AP_ERR_MSG_TYPE error.  If the key version indicated
by the Ticket in the KRB_AP_REQ is not one the server can use (e.g.,
it indicates an old key, and the server no longer possesses a copy of the old
key), the KRB_AP_ERR_BADKEYVER error is returned.  If the USE-SESSION-KEY flag is
set in the \fBap-options\fP field, it indicates to the server that the
ticket is encrypted in the session key from the server's
ticket-granting ticket rather than its secret key\**.
.FS
This is used in the Davis & Swick proposal.
.[ [
DavisSwick
.]]
.FE
Since it is
possible for the server to be registered in multiple realms, with
different keys in each, the \fBsrealm\fP field in the unencrypted portion of
the ticket in the KRB_AP_REQ is used to
specify which secret key the server should use to decrypt that ticket.
The KRB_AP_ERR_NOKEY error code is returned if the server doesn't have
the proper key to decipher the ticket.
.PP
The ticket is decrypted using the version of the server's key
specified by the ticket.  If the decryption routines detect a
modification of the ticket (each encryption system must provide
safeguards to detect modified ciphertext; see section ~sec enc_spec~), the
KRB_AP_ERR_BAD_INTEGRITY error is
returned (chances are good that different keys were used to encrypt
and decrypt).
.PP
The authenticator is decrypted using the session key extracted from
the decrypted ticket.  If decryption shows it to have been modified, the
KRB_AP_ERR_BAD_INTEGRITY error is returned.  The name and realm of the client
from the ticket are compared against the same fields in the
authenticator.  If they don't match, the KRB_AP_ERR_BADMATCH error is
returned (they might not match, for example, if the wrong session key
was used to encrypt the authenticator).  The addresses in the ticket (if
any) are then searched for
an address matching the operating-system reported address of the
client.  If no match is found or the server insists on ticket addresses but
none are present in the ticket, the KRB_AP_ERR_BADADDR error is returned.
.PP
If the local (server) time and the client time in the authenticator differ
by more than the allowable clock skew (e.g., 5 minutes), the
KRB_AP_ERR_SKEW error is returned.
If the server name, along with the client name, time and microsecond
fields from the Authenticator match any recently-seen such tuples,
the KRB_AP_ERR_REPEAT error is returned\**.
.FS
Note that the rejection here is
restricted to authenticators from the same principal to the same server.
Other client principals communicating with the same server principal
should not be have their authenticators rejected if the time and
microsecond fields happen to match some other client's authenticator.
.FE
The server must remember any authenticator
presented within the allowable clock skew, so that a replay attempt is
guaranteed to fail.  If a server loses track of any authenticator
presented within the allowable clock skew, it must reject all requests
until the clock skew interval has passed.  This assures that any lost or
re-played authenticators will fall outside the allowable clock skew and
can no longer be successfully replayed (If this is not done, an
attacker could conceivably record the ticket and authenticator sent over
the network to a server, then disable the
client's host, pose as the disabled host, and replay the ticket and
authenticator to subvert the authentication.).
If a sequence number is provided in the authenticator, the server saves
it for later use in processing KRB_SAFE and/or KRB_PRIV messages.
If a subkey is present, the server either saves it for later use or uses
it to help generate its own choice for a subkey to be returned in a
KRB_AP_REP message.
.PP
The server computes the age of the ticket: local (server) time minus the
start time inside the Ticket.
If the start time is later than the current time by more than the
allowable clock 
skew or if the INVALID flag is set in the ticket, the KRB_AP_ERR_TKT_NYV
error is returned.
Otherwise, if the current time is later than end time by more than the
allowable clock skew, the KRB_AP_ERR_TKT_EXPIRED error is returned.
.PP
If all these checks succeed without an error, the server is assured that
the client possesses the credentials of the principal named in the
ticket and thus, the client has been authenticated to the server.
See section ~sec ap_req_v_pc~ for pseudocode.
.N: sec 3 foo14 "Generation of a KRB_AP_REP message"
.PP
Typically, a client's request will include both the authentication
information and its initial request in the same message, and the server
need not explicitly reply to the KRB_AP_REQ.  However, if mutual
authentication (not only authenticating the client to the server, but
also the server to the client) is being performed, the KRB_AP_REQ
message will have MUTUAL-REQUIRED set in its ap-options field, and a
KRB_AP_REP message is required in response.  As with the error message,
this message may be encapsulated in the application protocol if its
"raw" form is not acceptable to the application's protocol.  The
timestamp and microsecond field used in the reply must be the client's
timestamp and microsecond field (as provided in the authenticator)\**.
.FS
In the Kerberos version 4 protocol, the timestamp in the reply was
the client's timestamp plus one.  This is not necessary in version 5
because version 5 messages are formatted in such a way that it is not
possible to create the reply by judicious message surgery (even in
encrypted form) without knowledge of the appropriate encryption keys.
.FE
If a sequence number is to be included, it should be randomly chosen as
described above for the authenticator.  A subkey may be included if the
server desires to negotiate a different subkey.
The KRB_AP_REP message is encrypted in the session key extracted from
the ticket.
See section ~sec ap_rep_g_pc~ for pseudocode.
.N: sec 3 foo15 "Receipt of KRB_AP_REP message"
.PP
If a KRB_AP_REP message is returned, the client uses the session key to
decrypt the message, and verifies that the timestamp and microsecond fields
match those in the Authenticator it sent to the server.
If they match, then the client is assured that the server is genuine.
The sequence number and subkey (if present) are retained for later use.
See section ~sec ap_rep_v_pc~ for pseudocode.
.N: sec 3 true_sess_key "Using the encryption key"
.PP
After the KRB_AP_REQ/KRB_AP_REP exchange has occurred, the client and
server share an encryption key which can be used by the application.
The "true session key" to be used for
KRB_PRIV, KRB_SAFE, or other application-specific uses may be chosen
by the application based on the subkeys in the KRB_AP_REP message and
authenticator\**.
.FS
Implementations of the protocol may wish to provide routines to choose
subkeys based on session keys and random numbers and to orchestrate a
negotiated key to be returned in the KRB_AP_REP message.
.FE
In some cases, the use of this session key will be implicit in the
protocol; in others the method of use must be chosen from a vast array
of alternatives.  We leave the protocol negotiations of how to use the
key (e.g.  selecting an encryption or checksum type) to the application
programmer; the Kerberos protocol does not constrain the
implementation options.
.PP
With both the one-way and mutual authentication exchanges, the peers
should take care not to send sensitive information to each other without
proper protection.  In particular, applications that require privacy or
integrity should use the KRB_AP_REP or KRB_ERROR responses from the
server to client to assure both client and server of their peer's
identity.  If an application protocol requires privacy of its messages,
it can use the KRB_PRIV message (section ~sec krb_priv~).  The KRB_SAFE message
(section ~sec krb_safe~) can be used to assure integrity.
.\" XXX fix wording?
