.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/CS_spec.ms,v $
.\"	$Author: jtkohl $
.\"	$Id: CS_spec.ms,v 1.30 90/12/19 17:06:05 jtkohl Exp $
.\"
.ds R# "$Id: CS_spec.ms,v 1.30 90/12/19 17:06:05 jtkohl Exp $
.N: sec 2 cs_spec "Client/Server (CS) message specifications"
.PP
This section specifies the format of the messages used for the
authentication of the client to the application server.
.N: sec 3 ap_req_def "KRB_AP_REQ definition"
.PP
The KRB_AP_REQ message contains the Kerberos protocol version number,
the message type KRB_AP_REQ, an options field to indicate any options
in use, and the ticket and authenticator themselves.  The KRB_AP_REQ
message is often referred to as the "authentication header".
.TS
center;
lb l l.
AP-REQ ::=	[APPLICATION 14] SEQUENCE {
	pvno[0]	INTEGER,
	msg-type[1]	INTEGER,
	ap-options[2]	APOptions,
	ticket[3]	Ticket,
	authenticator[4]	EncryptedData	-- Authenticator
}
.sp
APOptions ::=	BIT STRING {
	reserved(0),
	use-session-key(1),
	mutual-required(2)
}
.TE
.IP "\fBpvno\fP and \fBmsg-type\fP" 10
.br
These fields are described above in section ~sec kdc_req_def~.
\fBmsg-type\fP is KRB_AP_REQ.

.IP \fBap-options\fP 10
This field appears in the application request
(KRB_AP_REQ) and affects the way the request is processed.
It is a bit-field, where the selected
options are indicated by the bit being set (1), and the unselected options
and reserved fields being reset (0).  The encoding of the bits is
specified in section ~sec asn1_base~.  The meanings of the options are:
.TS
expand;
l l lw(4i).
.KS
\fIBit(s)	Name	Description\fP
.sp
0	RESERVED	T{
Reserved for future expansion of this field.
T}
.KE
.sp
1	USE-SESSION-KEY	T{
The USE-SESSION-KEY option indicates that the ticket the client is
presenting to a server is
encrypted in the session key from the server's ticket-granting ticket.
When this option is not specified, the ticket is encrypted in the
server's secret key.
T}
.sp
2	MUTUAL-REQUIRED	T{
The MUTUAL-REQUIRED option tells the server that the client requires
mutual authentication, and that it must respond with a KRB_AP_REP
message.
T}
.sp
3-31	RESERVED	T{
Reserved for future use.
T}
.TE

.IP \fBticket\fP 10
This field is a ticket authenticating the client to the server.

.IP \fBauthenticator\fP 10
.br
This contains the authenticator, which includes the client's choice of a
subkey.  Its encoding is described in section ~sec auth_def~.
.N: sec 3 ap_rep_def "KRB_AP_REP definition"
.PP
The KRB_AP_REP message contains the Kerberos protocol version number,
the message type, and an encrypted timestamp.  The message is sent in
in response to an application request (KRB_AP_REQ) where the mutual
authentication option has been selected in the \fBap-options\fP field.  
.KS
.TS
center;
lb l l.
AP-REP ::=	[APPLICATION 15] SEQUENCE {
	pvno[0]	INTEGER,
	msg-type[1]	INTEGER,
	enc-part[2]	EncryptedData	-- EncAPRepPart
}
.sp
EncAPRepPart ::=	[APPLICATION 27\(dg] SEQUENCE {
	ctime[0]	KerberosTime,
	cusec[1]	INTEGER,
	subkey[2]	EncryptionKey OPTIONAL,
	seq-number[3]	INTEGER OPTIONAL
}
.TE
.FS \(dg
An application code in the encrypted part of a
message provides an additional check that the message was decrypted
properly.
.FE
.KE
The encoded EncAPRepPart is encrypted in the shared session key of the
ticket.  The optional \fBsubkey\fP field can be used in an
application-arranged negotiation to choose a "true session key."

.IP "\fBpvno\fP and \fBmsg-type\fP" 10
.br
These fields are described above in section ~sec kdc_req_def~.
\fBmsg-type\fP is KRB_AP_REP.

.IP \fBenc-part\fP 10
This field is described above in section ~sec kdc_rep_def~.

.IP \fBctime\fP 10
This field contains the current time on the client's host.

.IP \fBcusec\fP 10
This field contains the microsecond part of the client's timestamp.

.IP \fBsubkey\fP 10
This field contains an encryption key which is to be used to protect
this specific application session.  See section ~sec true_sess_key~ for
specifics on how this field is used to negotiate a key.
.N: sec 3 foo20 "Error message reply"
.PP
If an error occurs while processing the application request, the
KRB_ERROR message will be sent in response.  See section
~sec krb_error_def~ for the format of the error message.
The \fBcname\fP and \fBcrealm\fP fields may be left out
if the server cannot determine their appropriate values from the
corresponding KRB_AP_REQ message.  If the authenticator was
decipherable, the \fBctime\fP and \fBcusec\fP fields will
contain the values from it.
