.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/Encryption_spec.ms,v $
.\"	$Author: jtkohl $
.\"	$Id: Encryption_spec.ms,v 1.7 91/06/07 17:28:37 jtkohl Exp $
.\"
.ds R# "$Id: Encryption_spec.ms,v 1.7 91/06/07 17:28:37 jtkohl Exp $
.N: sec 1 enc_spec "Encryption and Checksum Specifications"
.LP
The Kerberos protocols described in this document are designed to use
stream encryption ciphers, which can be simulated using commonly available
block encryption ciphers, such as the Data Encryption Standard,
.[ [
DESNBS
.]]
in conjunction with block chaining and checksum methods
.[ [
DESMODENBS
.]].
Encryption is used to prove the identities of the network entities
participating in message exchanges.  The Key Distribution Center for
each realm is trusted by all principals registered in that realm to store
a secret key in confidence.  Proof of knowledge of this private key is
used to verify the authenticity of a principal.
.PP
The KDC uses the principal's
secret key (in the AS exchange) or a shared session key (in the TGS
exchange) to encrypt responses to ticket
requests; the ability to obtain the secret key or session key implies
the knowledge of the appropriate keys and the identity of the KDC.
The ability of a principal to decrypt the KDC response and present a
Ticket and a properly formed Authenticator (generated with the session
key from the KDC response) to a service verifies the identity of the
principal; likewise the ability of the service to extract the session
key from the Ticket and prove its knowledge thereof in a response
verifies the identity of the service.
.PP
The Kerberos protocols generally assume that the encryption used is
secure from cryptanalysis; however, in some cases, the order of fields
in the encrypted portions of messages are arranged to minimize the
effects of poorly chosen keys.  It is still 
important to choose good keys.  \fBIf keys are derived from user-typed
passwords, those passwords need to be well chosen to make brute force
attacks more difficult.\fP  Poorly chosen keys still make easy targets
for intruders.
.PP
The following sections specify the encryption and checksum mechanisms
currently defined for Kerberos.  The encodings, chaining, and padding
requirements for each are described.  For encryption methods, it is
often desirable to place random information (often referred to as a
\fIconfounder\fP) at the start of the
message.  The requirements for a confounder are specified with each
encryption mechanism.
.PP
Some encryption systems use a block-chaining method to improve the
the security characteristics of the ciphertext.  However, these chaining
methods often don't provide an integrity check upon decryption.  Such
systems (such as DES in CBC mode) must be augmented with a checksum of
the plaintext which can be verified at decryption and used to detect any
tampering or damage.  Such checksums should be good at detecting burst
errors in the input.
If any damage is detected, the decryption routine
is expected to return an error indicating the failure of an integrity check.
Each encryption type is
expected to provide and verify an appropriate checksum.  The
specification of each encryption method sets out its checksum
requirements.  
.PP
Finally, where a key is to be derived from a user's password, an
algorithm for converting the password to a key of the appropriate type
is included.  It is desirable for the string to key function to be
one-way, and for the mapping to be different in different realms.
This is important because users who are registered in more than one
realm will often use the same password in each, and it is desirable
that an attacker compromising the Kerberos server in one realm not
obtain or derive the user's key in another.
.N: sec 2 enc_spec_def "Encryption Specifications"
.PP
The following ASN.1 definition describes all encrypted messages.  The
\fBenc-part\fP field which appears in the unencrypted part of messages
in section ~sec general_defs~ is a sequence consisting of an encryption
type, an optional key version number, and the ciphertext.
.PP
.TS
center;
lb l l.
EncryptedData ::=	SEQUENCE {
	etype[0]	INTEGER, -- EncryptionType
	kvno[1]	INTEGER OPTIONAL,
	cipher[2]	OCTET STRING -- ciphertext
}
.TE
.IP \fBetype\fP 10
This field identifies which encryption algorithm was used to encipher
the \fBcipher\fP.
Detailed specifications for selected encryption types appear later in
this section.

.IP \fBkvno\fP 10 
This field contains the version number of the key under which data is
encrypted.  It is only present in messages encrypted under long lasting
keys, such as principals' secret keys.

.IP \fBcipher\fP 10
This field contains the enciphered text, encoded as an OCTET STRING.

.PP
The \fBcipher\fP field is generated by applying the
specified encryption algorithm to data composed of the message and
algorithm-specific inputs.
Encryption mechanisms defined 
for use with Kerberos must take sufficient measures to guarantee the
integrity of the plaintext, and we recommend they also take measures to
protect against precomputed
dictionary attacks.  If the encryption algorithm is not itself capable
of doing so, the protections can often be enhanced by adding a
checksum and a confounder.
.PP
The suggested format for the data to be encrypted includes a
confounder, a checksum, the encoded plaintext, and any necessary padding.
The \fBmsg-seq\fP field contains the part of the protocol message
described in section ~sec general_defs~ which is to be encrypted.  The
confounder,
checksum, and padding are all untagged and untyped, and their length
is exactly sufficient to hold the appropriate item.  The type and length is
implicit and specified by the particular encryption type being used
(\fBetype\fP).  The format for the data to be encrypted is described
in the following diagram: 
.sp
.de C#
.ft C
.nf
..
.de #C
.ft R
.fi
..
.C#
      +-----------+----------+-------------+-----+
      |confounder |   check  |   msg-seq   | pad |
      +-----------+----------+-------------+-----+
.#C			
.sp
The format cannot be described in ASN.1, but for those who prefer an
ASN.1-\fIlike\fP notation:
.KS
.TS
center;
lb l l.
CipherText ::=	ENCRYPTED SEQUENCE {
	confounder[0]	UNTAGGED\(dg OCTET STRING(conf_length) OPTIONAL,
	check[1]	UNTAGGED OCTET STRING(checksum_length) OPTIONAL,
	msg-seq[2]	MsgSequence,
	pad	UNTAGGED OCTET STRING(pad_length) OPTIONAL
}	
.TE
.FS \(dg
In the above specification, UNTAGGED OCTET STRING(length) is
notation for an octet string with its tag and length removed.  It is
not a valid ASN.1 type.  The tag bits and length \fBmust\fP be removed
for the confounder
since the purpose of the confounder is so that the message starts with
random data, but the tag and its length are fixed.  For other fields,
the length and tag would be redundant if they were included because they are
specified by the encryption type.
.FE
.KE
.PP
One generates a random confounder of
the appropriate length, placing it in \fBconfounder\fP; zeroes out
\fBcheck\fP; calculates the
appropriate checksum over \fBconfounder\fP, \fBcheck\fP, and
\fBmsg-seq\fP, placing the result in \fBcheck\fP; adds the 
necessary padding; then encrypts using the specified encryption type
and the appropriate key.
.PP
Unless otherwise specified, a definition of
an encryption algorithm that specifies a checksum, a length for the
confounder field, or an octet boundary for padding uses this ciphertext
format\**.
.FS
Indeed, the ordering of these fields is important.  If the checksum is
placed after the msg-seq, then a chosen-plaintext attack which uses a
msg-seq with the form msg-seq'+cksum' can convince the recipient that
msg-seq' was sent, rather than the actual message msg-seq.  Note,
however, that any use of this message format needs to insure that
msg-seq encodes a length so that the recipient can verify that msg-seq
is not truncated in transit.  If the msg-seq is an encoding of an ASN.1
OCTET STRING, then a length indictation will automatically appear in
that encoding.
.FE
Those fields which are not specified will be omitted.
.PP
In the interest of allowing all implementations using a particular
encryption type to communicate with all others using that type, the
specification of an encryption type defines any checksum that is
needed as part of the encryption process.  If an alternative checksum
is to be used, a new encryption type must be defined.  
.PP
Some cryptosystems require additional information beyond the key and
the data to be encrypted.  For example, DES, when used in
cipher-block-chaining mode, requires an initialization vector.  If
required, the description for each encryption type must specify the
source of such additional information.
.N: sec 2 enc_key_def "Encryption Keys"
.PP
The sequence below shows the encoding of an encryption key:
.TS
center;
lb l l.
EncryptionKey ::=	SEQUENCE {
	keytype[0]	INTEGER,
	keyvalue[1]	OCTET STRING
}
.TE
.IP \fBkeytype\fP 10
This field specifies the
type of encryption key that follows in the \fBkeyvalue\fP field.  It
will almost always correspond to the encryption algorithm used to
generate the EncryptedData, though more than one algorithm may use the
same type of key (the mapping is many to one).  This might happen, for
example, if the encryption algorithm uses an alternate checksum
algorithm for an integrity check, or a different chaining mechanism.

.IP \fBkeyvalue\fP
This field contains the key itself, encoded as an octet string.
.PP
All negative values for the encryption key type are reserved for
local use.  All non-negative values are reserved for officially
assigned type fields and interpretations.
.N: sec 2 enc_systems "Encryption Systems"
.N: sec 3 foo30 "The NULL Encryption System (null)
.PP
If no encryption is in use, the encryption system is said to be the NULL
encryption system.  In the NULL encryption system there is no checksum,
confounder or padding.  The ciphertext is simply the plaintext.  The
NULL Key is used by the null encryption system and is zero octets in
length, with \fBkeytype\fP zero (0).
.N: sec 3 des-cbc-crc "DES in CBC mode with a CRC-32 checksum (des-cbc-crc)"
.PP
The \fBdes-cbc-crc\fP encryption mode encrypts information under the Data
Encryption Standard 
.[ [
DESNBS
.]]
using the cipher block chaining mode
.[ [
DESMODENBS
.]].
A
CRC-32 checksum (described in ISO 3309
.[ [
CRC32
.]])
is applied to the confounder and message sequence (\fBmsg-seq\fP) and
placed in the \fBcksum\fP field.  DES blocks are 8
bytes.  As a result, the data to be encrypted (the concatenation of
confounder, checksum, and message) must be padded to an 8 byte boundary
before encryption.
.PP
Plaintext and DES ciphtertext are encoded as 8-octet blocks which are
concatenated to make the 64-bit inputs for the DES algorithms.  The
first octet supplies the 8 most significant bits (with the octet's MSbit
used as the DES input block's MSbit, etc.), the second octet the next 8
bits, ..., and the eighth octet supplies the 8 least significant bits.
.PP
Encryption under DES using cipher block chaining
requires an additional input in the form of an initialization vector.
Unless otherwise specified, a copy of the key should be used as the
initialization vector.
.PP
The DES specifications identify some "weak keys"; those keys shall not
be used for encrypting messages for use in Kerberos.
.PP
A DES key is 8 octets of data, with \fBkeytype\fP
one (1).  This consists of 56 bits of key, and 8 parity bits (one per octet).
Kerberos' use of DES requires an 8-octet confounder.
The key is encoded as a series of 8 octets written in MSB-first order.
The bits within the key are also encoded in MSB order.  For example, if
the encryption key is
(B1,B2,...,B7,P1,B8,...,B14,P2,B15,...,B49,P7,B50,...,B56,P8)
where B1,B2,...,B56 are the key bits in MSB order, and P1,P2,...,P8 are
the parity bits, the first octet of the key would be
B1,B2,...,B7,P1
(with B1 as the MSbit).
[See the FIPS 81 introduction for reference.]
.PP
To generate a DES key from a text string (password), the text string
normally
must have the realm and each component of the principal's name
appended\**,
.FS
In some cases, it may be necessary to use a different "mix-in" string
for compatibility reasons; see the discussion of \fBpadata\fP in section
~sec kdc_rep_def~.
.FE
then padded with nulls to an 8 byte boundary.  This string
is then fan-folded and eXclusive-ORed with itself to form an 8 byte DES key.
The parity is corrected on the key, and it is used to generate a DES CBC
checksum on the initial string (with the realm and name appended).
Finally, parity is corrected on the CBC checksum and it is returned as
the key.  Pseudocode follows:
.sp
.de C#
.ft C
.nf
..
.de #C
.ft R
.fi
..
.C#
	string_to_key(string,realm,name) {
		odd = 1;
		s = string + realm;
		for(each component in name) {
			s = s + component;
		}
		tempkey = NULL;
		pad(s); /* with nulls to 8 byte boundary */
		for(8byteblock in s) {
			if(odd == 0)  { 
			    odd = 1;
			    reverse(8byteblock)
			} 
			else odd = 0;
			tempkey = tempkey XOR 8byteblock;
		}
		fixparity(tempkey);
		key = DES-CBC-check(s,tempkey);
		fixparity(key);
		return(key);
	}
.#C			
.N: sec 2 check_def "Checksums"
.PP
The following is the ASN.1 definition used for a checksum:
.TS
center;
lb l l.
Checksum ::=	SEQUENCE {
	cksumtype[0]	INTEGER,
	checksum[1]	OCTET STRING
}
.TE
.IP \fBcksumtype\fP 10
This field indicates the algorithm used to generate the accompanying checksum.
.IP \fBchecksum\fP 10
This field contains the checksum itself, encoded as an octet string.
.PP
Detailed specification of selected checksum types appear later in this
section.  Negative values for the checksum type are reserved for local
use.  All non-negative values are reserved for officially assigned type
fields and interpretations.
.PP
Checksums used by Kerberos can be classified by two properties:  whether
they are collision-proof, and whether they are keyed.
It is infeasible to find two plaintexts which generate the same checksum
value for a collision-proof checksum.
A key is required to perturb or initialize the algorithm in a keyed checksum.
To prevent message-stream modification by an active attacker,
unkeyed checksums should only be used when the checksum and message
will be subsequently encrypted (e.g. the checksums defined as part of
the encryption algorithms covered earlier in this section).
.\"XXX
Collision-proof checksums can be made tamper-proof as well if the
checksum value is encrypted before inclusion in a message.
In such cases, the composition of the checksum and the encryption
algorithm must be considered a separate checksum algorithm (e.g. RSA-MD4
encrypted using DES is a new checksum algorithm of type RSA-MD4-DES).
.N: sec 3 foo33 "The CRC-32 Checksum (crc32)"
.PP
The \fBCRC-32\fP checksum calculates a checksum based on a cyclic
redundancy check as described in ISO 3309
.[ [
CRC32
.]].
The resulting checksum is four (4) octets in length.  The CRC-32 is
neither keyed nor collision-proof, and is useful in Kerberos mainly to detect
modifications when included with plaintext that is encrypted.
.N: sec 3 foo34 "The RSA MD4 Checksum (rsa-md4)"
.PP
The \fBRSA-MD4\fP checksum calculates a checksum using the RSA MD4
algorithm
.[ [
MD4RFC
.]].
The algorithm takes as input an input message of arbitrary length and
produces as output a 128-bit (16 octet) checksum.  \fBRSA-MD4\fP is
believed to be collision-proof.
.N: sec 3 rsa_md4_des "RSA MD4 Cryptographic Checksum Using DES (rsa-md4-des)"
.PP
The \fBRSA-MD4-DES\fP checksum calculates a keyed collision-proof
checksum by applying the RSA MD4 checksum algorithm and encrypting the
results using DES in cipher-block-chaining (CBC) mode using a DES key as
both key and initialization vector.  The resulting checksum is 16 octets
long.  This checksum is tamper-proof and believed to be collision-proof.
.N: sec 3 des_cbc_cksum "DES cipher-block chained checksum (des-mac)"
.PP
The \fBDES-MAC\fP checksum is computed by performing a DES CBC-mode
encryption of the plaintext, and using the last block of the ciphertext
as the checksum value.  It is keyed with an encryption key and an
initialization vector; any uses which do not specify an additional
initialization vector will use the key as both key and initialization
vector.  The resulting checksum is 64 bits (8 octets) long.  This
checksum is tamper-proof and collision-proof.
.PP
The DES specifications identify some "weak keys"; those keys shall not
be used for generating DES-MAC checksums for use in Kerberos.
