.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/fielddefs.ms,v $
.\"	$Author: jtkohl $
.\"	$Header: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/fielddefs.ms,v 1.44 90/12/19 17:07:20 jtkohl Exp $
.\"
.ds R# "$Id: fielddefs.ms,v 1.44 90/12/19 17:07:20 jtkohl Exp $
.N: sec 1 fielddefs "Field Descriptions and Encodings"
.PP
This section describes the fields used in the protocol messages.  The
encodings of the fields, where defined for the Kerberos protocol, are
included with the field description.  Where parts of the encodings
have been specified independent from the Kerberos protocol, these
encodings are covered in section ~sec predef_types~.
.N: sec 2 fielddefs_specific "Field Descriptions"
.PP
Below is an alphabetical summary of the labels and descriptions of
fields used in the protocol messages.
.PP



.IP \fBconfounder\fP 10
.br
This field contains random data and appears at the beginning of data
to be encrypted.
Its purpose is to make
chosen- and known-plaintext attacks more difficult.  It is important to
note that
the existence of this field does not prevent a verifiable plaintext
attack.  It just prevents the use of a precomputed ciphertext
dictionary to find the corresponding plaintext.  The efficacy of the
confounder depends on the ability of the cryptosystem to propagate
changes at the start of the encrypted plaintext through the remainder
of the ciphertext.  The field is a string of octets without any
leading tag information.




.IP \fBpad\fP 10 
This field fills the data in a message to a boundary specified
by the cryptosystem in use.  Some cryptosystems may use part of the pad
to include an integrity checksum of the message.  The field is defined
as part of the description of individual cryptosystems.




.IP \fBticket\fP 10
This field contains a complete ticket.  Its encoding is specified in
section ~sec ticket_def~.

