#include "krb_locl.h"

RCSID("$Header: /afs/nada.kth.se/src/packages/kth-krb/SourceRepository/krb4/lib/krb/k_strerror.c,v 1.2 1995/10/24 10:14:32 bg Exp $");

const char *
k_strerror(int errnum)
{
#if HAVE_STRERROR
  return strerror(errnum);
#else
  extern int sys_nerr;
  extern char *sys_errlist[];
  static char ebuf[40];		/* 64-bit number + slop */

  if ((unsigned int)errnum < sys_nerr)
    return(sys_errlist[errnum]);
  (void)sprintf(ebuf, "Unknown error: %d", errnum);
  return(ebuf);
#endif /* !HAVE_STRERROR */
}

