/*
 * Header file for common error description library.
 *
 * Copyright 1988, Student Information Processing Board of the
 * Massachusetts Institute of Technology.
 *
 * For copyright and distribution info, see the documentation supplied
 * with this package.
 */

#ifndef __COM_ERR_H

#include <stdarg.h>

typedef void (*errf) (const char *, long, const char *, va_list);

/* ANSI C -- use prototypes etc */

/* com_err.c */
void com_err 			(const char*, long, const char*, ...);
errf set_com_err_hook		(errf new_proc);
errf reset_com_err_hook		(void);
void com_err_va 		(const char *whoami, long code, 
				 const char *fmt, va_list args);

/* error_message.c */
char* error_message	(long code);

#define __COM_ERR_H
#endif /* ! defined(__COM_ERR_H) */
