#include "kip.h"

RCSID("$Id: kip.c,v 1.4 1996/05/15 14:53:37 assar Exp $");

char *progname;

static void
usage()
{
     fprintf (stderr, "Usage: %s host\n",
	      progname);
     exit (1);
}

/*
 * Establish authenticated connection
 */

static int
connect_host (char *host, des_cblock *key, des_key_schedule schedule)
{
     CREDENTIALS cred;
     KTEXT_ST text;
     MSG_DAT msg;
     int status;
     struct sockaddr_in thisaddr, thataddr;
     int addrlen;
     struct hostent *hostent;
     int s;
     u_char b;

     hostent = gethostbyname (host);
     if (hostent == NULL) {
	  fprintf (stderr, "%s: gethostbyname '%s' failed: ", progname, host);
	  return -1;
     }

     memset (&thataddr, 0, sizeof(thataddr));
     thataddr.sin_family = AF_INET;
     thataddr.sin_port   = k_getportbyname ("kip", "tcp", htons(2112));
     memcpy (&thataddr.sin_addr, hostent->h_addr, sizeof(thataddr.sin_addr));

     s = socket (AF_INET, SOCK_STREAM, 0);
     if (s < 0) {
	  fprintf (stderr, "%s: socket failed: %s\n", progname,
		   strerror(errno));
	  return -1;
     }
     if (connect (s, (struct sockaddr *)&thataddr, sizeof(thataddr)) < 0) {
	  fprintf (stderr, "%s: connect(%s) failed: %s\n", progname, host,
		   strerror(errno));
	  return -1;
     }
     addrlen = sizeof(thisaddr);
     if (getsockname (s, (struct sockaddr *)&thisaddr, &addrlen) < 0 ||
	 addrlen != sizeof(thisaddr)) {
	  fprintf (stderr, "%s: getsockname(%s) failed: %s\n",
		   progname, host, strerror(errno));
	  return -1;
     }
     status = krb_sendauth (KOPT_DO_MUTUAL, s, &text, "rcmd",
			    host, krb_realmofhost (host),
			    getpid(), &msg, &cred, schedule,
			    &thisaddr, &thataddr, "KIPSRV.0");
     if (status != KSUCCESS) {
	  fprintf (stderr, "%s: %s: %s\n", progname, host,
		   krb_get_err_text(status));
	  return -1;
     }
     if (read (s, &b, sizeof(b)) != sizeof(b)) {
	  fprintf (stderr, "%s: read: %s\n", progname,
		   strerror(errno));
	  return -1;
     }
     if (b) {
	  char buf[BUFSIZ];

	  read (s, buf, sizeof(buf));
	  buf[BUFSIZ - 1] = '\0';

	  fprintf (stderr, "%s: %s: %s\n", progname, host, buf);
	  return -1;
     }

     memcpy(key, &cred.session, sizeof(des_cblock));
     return s;
}

/*
 * Connect to the given host.
 */

static int
doit (char *host)
{
     des_key_schedule schedule;
     des_cblock iv;
     int other, this;
     struct ifreq ifreq;
     int sock;

     other = connect_host (host, &iv, schedule);
     if (other < 0)
	  return 1;
     this = tunnel_open ();
     if (this < 0)
	  return 1;
     return copy_packets (this, other, TUNMTU, &iv, schedule);
}

/*
 * kip - forward IP packets over a kerberos-encrypted channel.
 *
 */

int
main(int argc, char **argv)
{
     progname = argv[0];
     if (argc != 2)
	  usage ();
     return doit (argv[1]);
}
