#include "kip.h"

RCSID("$Id: kipd.c,v 1.4 1996/05/15 14:53:51 assar Exp $");

#include <syslog.h>

char *progname;

static int
fatal (int fd, char *s)
{
     u_char err = 1;

     write (fd, &err, sizeof(err));
     write (fd, s, strlen(s)+1);
     syslog(LOG_ERR, s);
     return err;
}

static int
recv_conn (int sock, des_cblock *key, des_key_schedule schedule,
	   struct sockaddr_in *retaddr)
{
     int status;
     KTEXT_ST ticket;
     AUTH_DAT auth;
     char instance[INST_SZ + 1];
     struct sockaddr_in thisaddr, thataddr;
     int addrlen;
     char version[KRB_SENDAUTH_VLEN];
     u_char ok = 0;
     struct passwd *passwd;

     addrlen = sizeof(thisaddr);
     if (getsockname (sock, (struct sockaddr *)&thisaddr, &addrlen) < 0 ||
	 addrlen != sizeof(thisaddr)) {
	  return 1;
     }
     addrlen = sizeof(thataddr);
     if (getpeername (sock, (struct sockaddr *)&thataddr, &addrlen) < 0 ||
	 addrlen != sizeof(thataddr)) {
	  return 1;
     }

     k_getsockinst (sock, instance);
     status = krb_recvauth (KOPT_DO_MUTUAL, sock, &ticket, "rcmd", instance,
			    &thataddr, &thisaddr, &auth, "", schedule,
			    version);
     if (status != KSUCCESS ||
	 strncmp(version, "KIPSRV.0", KRB_SENDAUTH_VLEN) != 0) {
	  return 1;
     }
     passwd = k_getpwnam ("root");
     if (passwd == NULL)
	  return fatal (sock, "Cannot find root");
     if (kuserok(&auth, "root") != 0)
	  return fatal (sock, "Permission denied");
     if (write (sock, &ok, sizeof(ok)) != sizeof(ok))
	  return 1;

     memcpy(key, &auth.session, sizeof(des_cblock));
     *retaddr = thataddr;
     return 0;
}

static int
doit(int sock)
{
     struct sockaddr_in thataddr;
     des_key_schedule schedule;
     des_cblock key;
     int this;

     if (recv_conn (sock, &key, schedule, &thataddr))
	  return 1;
     this = tunnel_open ();
     if (this < 0)
	  fatal (sock, "Cannot open " _PATH_DEV TUNDEV);
     return copy_packets (this, sock, TUNMTU, &key, schedule);
}

/*
 * kipd - receive forwarded IP
 */

int
main (int argc, char **argv)
{
     progname = argv[0];

     openlog(progname, LOG_PID|LOG_CONS, LOG_DAEMON);
     signal (SIGCHLD, childhandler);
     return doit(0);
}
