#include "config.h"
#include "protos.h"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif /* !HAVE_SYS_TIME_H */
#endif /* !TIME_WITH_SYS_TIME */

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#include <errno.h>
#include <signal.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

extern char *optarg;
extern int optind; /*, opterr; */

#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif /* HAVE_SYS_RESOURCE_H */
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_PWD_H
#include <pwd.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif

#include <com_err.h>
#include <ss/ss.h>

#include <des.h>
#include <krb.h>
#include <krb_err.h>
#include <krb_db.h>
#include <kadm.h>
#include <kadm_err.h>
#include <acl.h>

#include "kadm_server.h"
#include "pw_check.h"

/* from libacl */
/* int acl_check(char *acl, char *principal); */

/* GLOBALS */
extern char *acldir;
extern Kadm_Server server_parm;

/* Utils */
int kadm_change __P((char *, char *, char *, des_cblock));
int kadm_add_entry __P((char *, char *, char *, Kadm_vals *, Kadm_vals *));
int kadm_mod_entry __P((char *, char *, char *, Kadm_vals *, Kadm_vals *, Kadm_vals *));
int kadm_get_entry __P((char *, char *, char *, Kadm_vals *, u_char *, Kadm_vals *));
int kadm_ser_cpw __P((u_char *, int, AUTH_DAT *, u_char **, int *));
int kadm_ser_add __P((u_char *, int, AUTH_DAT *, u_char **, int *));
int kadm_ser_mod __P((u_char *, int, AUTH_DAT *, u_char **, int *));
int kadm_ser_get __P((u_char *, int, AUTH_DAT *, u_char **, int *));
int kadm_ser_init __P((int inter, char realm[]));
int kadm_ser_in __P((u_char **, int *));

int get_pw_new_pwd(char *pword, int pwlen, char *name, char *inst,
		    char *realm, int print_realm);

void change_password __P((int argc, char *argv[]));
void change_key __P((int argc, char *argv[]));
void change_admin_password __P((int argc, char *argv[]));
void add_new_key __P((int argc, char *argv[]));
void get_entry __P((int argc, char *argv[]));
void mod_entry __P((int argc, char *argv[]));
void help __P((int argc, char *argv[]));
void clean_up __P((void));
void quit __P((void));
