#include "krb_locl.h"

RCSID("$Id: decomp_ticket.c,v 1.10 1996/07/22 11:58:44 joda Exp $");

/*
 * This routine takes a ticket and pointers to the variables that
 * should be filled in based on the information in the ticket.  It
 * fills in values for its arguments.
 *
 * The routine returns KFAILURE if any of the "pname", "pinstance",
 * or "prealm" fields is too big, otherwise it returns KSUCCESS.
 *
 * The corresponding routine to generate tickets is create_ticket.
 * When changes are made to this routine, the corresponding changes
 * should also be made to that file.
 *
 * See create_ticket.c for the format of the ticket packet.
 */

/* The ticket to be decoded */
/* Kerberos ticket flags */
/* Authentication name */
/* Principal's instance */
/* Principal's authentication domain */
/* Net address of entity requesting ticket */
/* Session key inserted in ticket */
/* Lifetime of the ticket */
/* Issue time and date */
/* Service name */
/* Service instance */
/* Service's secret key (to decrypt the ticket) */
/* The precomputed key schedule */
int
decomp_ticket(KTEXT tkt, unsigned char *flags, 
	      char *pname, char *pinstance, char *prealm, 
	      u_int32_t *paddress, unsigned char *session, 
	      int *life, u_int32_t *time_sec, 
	      char *sname, char *sinstance, 
	      des_cblock *key, des_key_schedule schedule)
{
    unsigned char *p = tkt->dat;
    
    int little_endian;

    des_pcbc_encrypt((des_cblock *)tkt->dat, (des_cblock *)tkt->dat,
		     tkt->length, schedule, key, DES_DECRYPT);

    *flags = *p++;

    little_endian = (*flags >> K_FLAG_ORDER) & 1;

    if(strlen((char*)p) > ANAME_SZ)
	return KFAILURE;
    p += get_string(p, pname);

    if(strlen((char*)p) > INST_SZ)
	return KFAILURE;
    p += get_string(p, pinstance);

    if(strlen((char*)p) > REALM_SZ)
	return KFAILURE;
    p += get_string(p, prealm);

    p += get_address(p, paddress);

    memcpy(session, p, 8);
    p += 8;

    *life = *p++;
    
    p += get_int(p, time_sec, 4, little_endian);

    p += get_string(p, sname);

    p += get_string(p, sinstance);

    return KSUCCESS;
}
