#include "krb_locl.h"

RCSID("$Id: k_getport.c,v 1.5 1996/06/05 05:38:27 joda Exp $");

int
k_getportbyname (const char *service, const char *proto, int default_port)
{
#ifdef HAVE_GETSERVBYNAME  
    struct servent *sp;
    
    sp = getservbyname(service, proto);
    if(sp != NULL)
	return sp->s_port;
    
    fprintf (stderr, "%s/%s unknown service, using default port %d\n", 
	     service, proto, ntohs(default_port));
#endif
    return default_port;
}
