#include "krb_locl.h"

RCSID("$Id: k_getsockinst.c,v 1.3 1996/03/25 13:09:31 bg Exp $");

/*
 * Return in inst the name of the local interface bound to socket
 * fd. On Failure return the 'wildcard' instance "*".
 */

int
k_getsockinst(int fd, char *inst)
{
  struct sockaddr_in addr;
  int len = sizeof(addr);
  struct hostent *hnam;
  char *t;

  if (getsockname(fd, (struct sockaddr *)&addr, &len) < 0)
    goto fail;

  hnam = gethostbyaddr((char *)&addr.sin_addr,
		       sizeof(addr.sin_addr),
		       addr.sin_family);
  if (hnam == 0)
    goto fail;

  for (t = hnam->h_name; *t && *t != '.'; t++)
    *inst++ = *t;
  *inst = 0;
  return 0;			/* Success */

 fail:
  inst[0] = '*';
  inst[1] = 0;
  return -1;
}
