#include "krb_locl.h"

RCSID("$Id: verify_user.c,v 1.2 1996/06/14 09:41:27 assar Exp $");

/* Verify user with password. If secure, also verify against local
 * service key, this can (usually) only be done by root.
 *
 * As a side effect, fresh tickets are obtained.
 *
 * Returns zero if ok, a positive kerberos error or -1 for system
 * errors.
 */

int
krb_verify_user(char *name, char *instance, char *realm, char *password, 
		int secure, char *linstance)
{
    int ret;
    ret = krb_get_pw_in_tkt(name, instance, realm,
			    "krbtgt", realm,
			    DEFAULT_TKT_LIFE, password);
    if(ret != KSUCCESS)
	return ret;

    if(secure){
	struct hostent *hp;
	int32_t addr;
	
	KTEXT_ST ticket;
	AUTH_DAT auth;

	char lrealm[REALM_SZ];
	char hostname[MaxHostNameLen];
	char *phost;

	if (k_gethostname(hostname, sizeof(hostname)) == -1) {
	    dest_tkt();
	    return -1;
	}

	hp = gethostbyname(hostname);
	if(hp == NULL){
	    dest_tkt();
	    return -1;
	}
	memmove(&addr, hp->h_addr, sizeof(addr));

	ret = krb_get_lrealm(lrealm, 0);
	if(ret != KSUCCESS){
	    dest_tkt();
	    return ret;
	}
	phost = krb_get_phost(hostname);
	
	if (linstance == NULL)
	    linstance = "rcmd";

	ret = krb_mk_req(&ticket, linstance, phost, lrealm, 33);
	if(ret != KSUCCESS){
	    dest_tkt();
	    return ret;
	}
	
	ret = krb_rd_req(&ticket, linstance, phost, addr, &auth, "");
	if(ret != KSUCCESS){
	    dest_tkt();
	    return ret;
	}
    }
    return 0;
}
		
