#include "krb_locl.h"

RCSID("$Id: kdc_reply.c,v 1.4 1996/08/17 14:31:37 assar Exp $");

static int little_endian; /* XXX ugly */

int
kdc_reply_cred(KTEXT cip, CREDENTIALS *cred)
{
    unsigned char *p = cip->dat;
    
    memcpy(cred->session, p, 8);
    p += 8;
    
    if(p + strlen((char*)p) > cip->dat + cip->length)
	return INTK_BADPW;
    p += krb_get_string(p, cred->service);
    
    if(p + strlen((char*)p) > cip->dat + cip->length)
	return INTK_BADPW;
    p += krb_get_string(p, cred->instance);
    
    if(p + strlen((char*)p) > cip->dat + cip->length)
	return INTK_BADPW;
    p += krb_get_string(p, cred->realm);
    
    cred->lifetime = *p++;
    cred->kvno = *p++;
    cred->ticket_st.length = *p++;
    
    memcpy(cred->ticket_st.dat, p, cred->ticket_st.length);
    p += cred->ticket_st.length;
    
    p += krb_get_int(p, (u_int32_t *)&cred->issue_date, 4, little_endian);
    
    return KSUCCESS;
}

int kdc_reply_cipher(KTEXT reply, KTEXT cip)
{
    unsigned char *p;
    unsigned char pvno;
    unsigned char type;

    char aname[ANAME_SZ];
    char inst[INST_SZ];
    char realm[REALM_SZ];
    
    u_int32_t kdc_time;
    u_int32_t exp_date;
    u_int32_t clen;

    p = reply->dat;

    pvno = *p++;

    if (pvno != KRB_PROT_VERSION )
        return INTK_PROT;
    
    type = *p++;
    little_endian = type & 1;
    
    type &= ~1;

    if(type == AUTH_MSG_ERR_REPLY){
	u_int32_t code;
	p += strlen((char*)p) + 1; /* name */
	p += strlen((char*)p) + 1; /* instance */
	p += strlen((char*)p) + 1; /* realm */
	p += 4; /* time */
	p += krb_get_int(p, &code, 4, little_endian);
	return code;
    }
    if(type != AUTH_MSG_KDC_REPLY)
	return INTK_PROT;

    p += krb_get_nir(p, aname, inst, realm);
    p += krb_get_int(p, &kdc_time, 4, little_endian);
    p++; /* number of tickets */
    p += krb_get_int(p, &exp_date, 4, little_endian);
    p++; /* master key version number */
    p += krb_get_int(p, &clen, 2, little_endian);
    cip->length = clen;
    memcpy(cip->dat, p, clen);
    p += clen;
    
    return KSUCCESS;
}
