// TelnetEngine.h
// Author: Jrgen Karlsson - d93-jka@nada.kth.se
#ifndef TELNETENGINE_H

#ifndef TELNETSESSION_H
#include "TelnetSession.h"
#endif

#define TELNETENGINE_H

#include <winsock.h>
#include "CharStream.h"
#include "Negotiator.h"
#include "CryptoEngine.h"
extern "C" {
#include <kclient.h>
}

enum	{		SM_READ = WM_USER,	// Socket Message Read,
									// data available for reading.
		};

class TelnetEngine
{
public:
	void DeleteDoubleIAC(unsigned char* Buffer, unsigned int* Size);
	void ReadSocket(void);
	void InvokeOption(unsigned char Option, unsigned int Command, void* Data = NULL);
	void SendCommand(const int command);
	HANDLE mRecEvent;
	HANDLE mRecThread;

	BOOL mDecrypt;
	BOOL mEncrypt;
	BOOL mAuthenticated;
	unsigned char enckey[8];
	TelnetEngine(TelnetSession *thisTelnetSession);
	TelnetSession* mTelnetSession;
	void Close(void);
	void Receive(char* buffer, unsigned int buf_size);
	static unsigned long WINAPI TelnetEngine::RecvThread(
		void *thisTelnetEngine);
	Negotiator *mNegotiator;
	void Send(char *buf, int bufSZ);
	void TelnetNegotiate(CharStream *RecStream);
	
	 
	CharStream		mRawStream,	// Used	by receive thread to store incoming data.
					mRecStream;	// Sent to TelnetSession.
	BOOL Connect(char *hostname);
	SOCKET mSocket;
	KClientSessionInfo mKClientSession;

	CryptoEngine* mCryptoEngine;

private:
};


#endif // TELNETENGINE_H