// TerminalEngine.h
// Author: Jrgen Karlsson - d93-jka@nada.kth.se

#ifndef TERMINALENGINE_H
#define TERMINALENGINE_H

#include <Windows.h>

#ifndef TELNETSESSION_H
class TelnetSession;
#endif // TELNETSESSION_H

typedef		unsigned char		AttributeWord;
enum
{	
			BOLD		=	1<<0,
			UNDERSCORE	=	1<<1,
			BLINK		=	1<<2,
			REVERSE		=	1<<3,
};

class TerminalEngine
{
public:
	void SetOriginRelative(int How);
	int AdjustCharOrigin(void);
	char* LCtoAddr(void* BaseAddr, int row, int col);
	int LCtoBC(int *Row, int* Col);
	BOOL SizeChanged;
	int GetCharWindowSize(int *Cols, int* Rows);
	int GetWindowSize(int* Width, int* Height);
	void UpdateCaret(void);
	void InvalidateRows(unsigned int topRow, unsigned int bottomRow);
	BOOL BuildPrintable(int curRow, RECT *bounds,
						char *Buf, int maxBufLen,
						int *BufLen, AttributeWord *Attr);

	

	void SetAttribute(AttributeWord AttrWord);
	void ClearAttribute(AttributeWord AttrWord);
	void Redraw(RECT invRect);
	
	HWND mWindow;
	HDC mHDC;
	
	void SetWindowSize(int x, int y);
	void SetOrigin(int x, int y);
	char* Cur2Addr(void* BaseAddr, int row, int col);
	void ClearScreen(void);
	void ClearScreenToCursor(void);
	void ClearScreenFromCursor(void);
	void ClearLineToCursor(void);
	void ClearLineFromCursor(void);
	void ScrollRows(int ScrRegTop, int ScrRegBot, int rows);
	void GetCursorPos(int *x, int *y);
	void PlaceCursor(int x, int y);
	void MoveCursor(int x, int y);
	TelnetSession * mTelnetSession;
	~TerminalEngine(void);
	TerminalEngine(TelnetSession* );
	CharStream * mRecStream;
	BOOL AdjustOrigin(void);
	void Clear(void);
	void Scroll(int Rows);
	int mWindowHeight;
	int mWindowWidth;
	void Close(void);
	void RedrawAll(void);
	void DrawText(unsigned char *buf, unsigned int buflen);
	void Open(void);
	static LRESULT CALLBACK WindowProc(HWND window, UINT msg, WPARAM wParam, LPARAM lParam);

	int mCharHeight;
	int mCharWidth;
 	POINT mCursor, mOrigin;

private:
	POINT mBufSZ;
	char *mBuffer;
	AttributeWord		mCurrentAttr,	*mAttrBuffer;				

	HFONT stdFont;
 	HFONT boldFont; 
	HFONT uscoreFont, bolduscoreFont;

	COLORREF mTextColor;
	COLORREF mBkColor;
};

#endif // TERMINALENGINE_H